/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplane.conf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import nl.sascom.backplane.conf.Version;
import nl.sascom.backplanepublic.common.Response;

public class BuiltVersion
implements Version {
    private int major;
    private int minor;
    private int patch;
    private LocalDateTime buildDateTime;

    private BuiltVersion(int n, int n2, int n3, LocalDateTime localDateTime) {
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.buildDateTime = localDateTime;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setPatch(int n) {
        this.patch = n;
    }

    @Override
    public String getVersionString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public LocalDateTime getBuildDateTime() {
        return this.buildDateTime;
    }

    public void setBuildDateTime(LocalDateTime localDateTime) {
        this.buildDateTime = localDateTime;
    }

    public static BuiltVersion of(JsonNode jsonNode) {
        int n = jsonNode.get("major").asInt();
        int n2 = jsonNode.get("minor").asInt();
        int n3 = jsonNode.get("patch").asInt();
        LocalDateTime localDateTime = null;
        if (jsonNode.has("build_date_time")) {
            String string = jsonNode.get("build_date_time").asText();
            localDateTime = DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)string, LocalDateTime::from);
        }
        return new BuiltVersion(n, n2, n3, localDateTime);
    }

    public ObjectNode toJson() {
        ObjectNode objectNode = Response.createObject();
        if (this.buildDateTime != null) {
            objectNode.put("build_date_time", DateTimeFormatter.ISO_DATE_TIME.format(this.buildDateTime));
        }
        objectNode.put("version_string", this.getVersionString());
        objectNode.put("major", this.major);
        objectNode.put("minor", this.minor);
        objectNode.put("patch", this.patch);
        return objectNode;
    }

    public BuiltVersion incrementPatch(LocalDateTime localDateTime) {
        return new BuiltVersion(this.major, this.minor, this.patch + 1, localDateTime);
    }

    public static BuiltVersion of(int n, int n2, int n3, LocalDateTime localDateTime) {
        return new BuiltVersion(n, n2, n3, localDateTime);
    }

    public boolean hasBuiltDateTime() {
        return this.buildDateTime != null;
    }

    public static BuiltVersion of(String string, LocalDateTime localDateTime) {
        String[] stringArray = string.split("\\.");
        BuiltVersion builtVersion = new BuiltVersion(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), localDateTime);
        return builtVersion;
    }
}

