/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import nl.bimbase.bimworks.client.BimWorksClient;
import nl.bimbase.bimworks.client.BimWorksException;
import nl.bimbase.bimworks.client.TreeNode;
import nl.bimbase.bimworks.client.TreeNodeVersion;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;

public class FileSystemApi {
    private final BimWorksClient bimWorksClient;

    public FileSystemApi(BimWorksClient bimWorksClient) {
        this.bimWorksClient = bimWorksClient;
    }

    public UUID createNode(UUID uUID, String string, boolean bl) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("CreateNode");
        request.put("parent_node_uuid", uUID.toString());
        request.put("name", string);
        request.put("folder", bl);
        return UUID.fromString(this.bimWorksClient.executeAsyncTask(request).asText());
    }

    public void deleteNodeIfExists(String string) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("DeleteNodeIfExists");
        request.put("path", string);
        this.bimWorksClient.executeAsyncTask(request);
    }

    public void deleteNode(UUID uUID) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("DeleteNode");
        request.put("node_uuid", uUID.toString());
        this.bimWorksClient.executeAsyncTask(request);
    }

    public void deleteNodeVersion(UUID uUID, UUID uUID2) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("DeleteNodeVersion");
        request.put("node_uuid", uUID.toString());
        request.put("version_uuid", uUID2.toString());
        this.bimWorksClient.executeAsyncTask(request);
    }

    public void deleteNodeError(UUID uUID, UUID uUID2) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("DeleteNodeError");
        request.put("node_uuid", uUID.toString());
        request.put("error_uuid", uUID2.toString());
        this.bimWorksClient.executeAsyncTask(request);
    }

    public void undeleteNode(UUID uUID) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("UndeleteNode");
        request.put("node_uuid", uUID.toString());
        this.bimWorksClient.executeAsyncTask(request);
    }

    public TreeNode getRootNode() throws BimWorksException {
        return this.getNodeByPath("/");
    }

    public UUID createNodeIfNotExists(UUID uUID, String string, boolean bl) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("CreateNodeIfNotExists");
        request.put("name", string);
        request.put("parent_node_uuid", uUID.toString());
        request.put("folder", bl);
        return UUID.fromString(this.bimWorksClient.executeAsyncTask(request).asText());
    }

    public TreeNode getNodeByUuid(UUID uUID) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("GetNodeByUuid");
        request.getObjectInput().put("node_uuid", uUID.toString());
        return (TreeNode)Response.OBJECT_MAPPER.convertValue((Object)this.bimWorksClient.executeAsyncTask(request), TreeNode.class);
    }

    public TreeNodeVersion getNodeVersion(UUID uUID) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("GetNodeVersion");
        request.getObjectInput().put("version_uuid", uUID.toString());
        return (TreeNodeVersion)Response.OBJECT_MAPPER.convertValue((Object)this.bimWorksClient.executeAsyncTask(request), TreeNodeVersion.class);
    }

    public TreeNode getNodeByVersionUuid(UUID uUID) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("GetNodeByVersionUuid");
        request.getObjectInput().put("version_uuid", uUID.toString());
        return (TreeNode)Response.OBJECT_MAPPER.convertValue((Object)this.bimWorksClient.executeAsyncTask(request), TreeNode.class);
    }

    public ObjectNode listNodes(UUID uUID) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("ListNodes");
        request.getObjectInput().put("parent_node_uuid", uUID.toString());
        request.setTimeOut(1L, TimeUnit.MINUTES);
        return (ObjectNode)this.bimWorksClient.executeAsyncTask(request);
    }

    public ArrayNode listNodeErrors(UUID uUID) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("ListNodeErrors");
        request.getObjectInput().put("node_uuid", uUID.toString());
        request.setTimeOut(1L, TimeUnit.MINUTES);
        return (ArrayNode)this.bimWorksClient.executeAsyncTask(request);
    }

    public ArrayNode listNodeVersions(UUID uUID) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("ListNodeVersions");
        request.getObjectInput().put("node_uuid", uUID.toString());
        request.setTimeOut(1L, TimeUnit.MINUTES);
        return (ArrayNode)this.bimWorksClient.executeAsyncTask(request);
    }

    public ObjectNode listNodesRecursive(UUID uUID) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("ListNodesRecursive");
        request.getObjectInput().put("node_uuid", uUID.toString());
        request.setTimeOut(1L, TimeUnit.MINUTES);
        return (ObjectNode)this.bimWorksClient.executeAsyncTask(request);
    }

    public TreeNode getNodeByPath(String string) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("GetNodeByPath");
        request.getObjectInput().put("path", string);
        request.setTimeOut(1L, TimeUnit.MINUTES);
        return (TreeNode)BimWorksClient.OBJECT_MAPPER.convertValue((Object)this.bimWorksClient.executeAsyncTask(request), TreeNode.class);
    }

    public boolean exists(String string) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("NodeExists");
        request.put("path", string);
        request.setTimeOut(1L, TimeUnit.MINUTES);
        return this.bimWorksClient.executeAsyncTask(request).asBoolean();
    }

    public UUID getRootNodeUuid() throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("GetNodeByPath");
        request.put("path", "/");
        return UUID.fromString(this.bimWorksClient.executeAsyncTask(request).get("uuid").asText());
    }

    public int clearNodeChildren() throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("ClearNodeChildren");
        request.put("node_uuid", this.getRootNodeUuid().toString());
        request.setTimeOut(10L, TimeUnit.MINUTES);
        return this.bimWorksClient.executeAsyncTask(request).get("uuid").asInt();
    }

    public ObjectNode listNodes(String string) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("ListNodes");
        request.getObjectInput().put("path", string);
        request.setTimeOut(1L, TimeUnit.MINUTES);
        return (ObjectNode)this.bimWorksClient.executeAsyncTask(request);
    }
}

