/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import nl.bimbase.bimworks.actions.Discipline;
import nl.bimbase.bimworks.client.BimQuery;
import nl.bimbase.bimworks.client.BimWorksClient;
import nl.bimbase.bimworks.client.BimWorksException;
import nl.sascom.backplanepublic.common.ClientTask;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;

public class Bim {
    private BimWorksClient bimWorksClient;

    public Bim(BimWorksClient bimWorksClient) {
        this.bimWorksClient = bimWorksClient;
    }

    public ArrayNode query(BimQuery bimQuery, String[] stringArray, Set<UUID> set) throws BimWorksException, InterruptedException {
        return this.query(bimQuery, stringArray, set.toArray(new UUID[0]));
    }

    public ArrayNode query(BimQuery bimQuery, String[] arrayNode, UUID ... uUIDArray) throws BimWorksException, InterruptedException {
        Request request = this.bimWorksClient.createRequest();
        request.setTaskName("TableExport");
        request.put("type", "JSON");
        request.put("output", "RESPONSE");
        request.getObjectInput().set("query", (JsonNode)bimQuery.toJson());
        ArrayNode arrayNode2 = Response.createArray();
        for (String string : arrayNode) {
            arrayNode2.add(string);
        }
        request.getObjectInput().set("paths", (JsonNode)arrayNode2);
        ArrayNode arrayNode3 = Response.createArray();
        for (UUID uUID : uUIDArray) {
            arrayNode3.add(uUID.toString());
        }
        request.getObjectInput().set("models", (JsonNode)arrayNode3);
        request.setTimeOut(1L, TimeUnit.MINUTES);
        ClientTask clientTask = this.bimWorksClient.createAsyncTask(request);
        try {
            clientTask.exec();
            return clientTask.await(1L, TimeUnit.MINUTES).getArrayOutput();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }

    public ObjectNode queryDelegated(BimQuery bimQuery, String[] arrayNode, Duration duration, UUID ... uUIDArray) throws BimWorksException, InterruptedException {
        Request request = this.bimWorksClient.createRequest();
        request.setTaskName("GenerateQueryToken");
        request.getObjectInput().set("query", (JsonNode)bimQuery.toJson());
        request.getObjectInput().put("expires_seconds", duration.toMillis());
        request.getObjectInput().put("type", "JSON");
        request.getObjectInput().put("output", "RESPONSE");
        ArrayNode arrayNode2 = Response.createArray();
        for (String string : arrayNode) {
            arrayNode2.add(string);
        }
        request.getObjectInput().set("paths", (JsonNode)arrayNode2);
        ArrayNode arrayNode3 = Response.createArray();
        for (UUID uUID : uUIDArray) {
            arrayNode3.add(uUID.toString());
        }
        request.getObjectInput().set("models", (JsonNode)arrayNode3);
        request.setTimeOut(1L, TimeUnit.MINUTES);
        ClientTask clientTask = this.bimWorksClient.createAsyncTask(request);
        try {
            clientTask.exec();
            return clientTask.await(1L, TimeUnit.MINUTES).getObjectOutput();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }

    public ArrayNode queryWithToken(ObjectNode objectNode) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.setInput(objectNode.get("input"));
        request.setTask((ObjectNode)objectNode.get("task"));
        request.setTimeOut(4L, TimeUnit.HOURS);
        ClientTask clientTask = this.bimWorksClient.createAsyncTask(request);
        try {
            clientTask.exec();
            return clientTask.await(4L, TimeUnit.HOURS).getArrayOutput();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            throw new BimWorksException(interruptedException.getMessage());
        }
    }

    public void setDiscipline(UUID uUID, Discipline discipline) throws BimWorksException {
        Request request = this.bimWorksClient.createRequest();
        request.getObjectInput().put("discipline", discipline.name());
        request.getObjectInput().put("model", uUID.toString());
        request.setTaskName("SetDiscipline");
        request.setTimeOut(4L, TimeUnit.HOURS);
        ClientTask clientTask = this.bimWorksClient.createAsyncTask(request);
        try {
            clientTask.exec();
            clientTask.await(4L, TimeUnit.HOURS);
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            throw new BimWorksException(interruptedException.getMessage());
        }
    }
}

