package nl.bimbase.bimworks.client;

import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonProperty;

public class TreeNode {
	@JsonProperty("uuid")
	private UUID uuid;
	
	@JsonProperty("name")
	private String name;

	@JsonProperty("versions")
	private List<TreeNodeVersion> versions;

	@JsonProperty("errors")
	private List<TreeNodeError> errors;
	
	@JsonProperty("parent_node_uuid")
	private UUID parentNodeUuid;
	
	@JsonProperty("root_node_uuid")
	private UUID rootNodeUuid;
	
	@JsonProperty("has_loadable_children")
	private boolean hasLoadableChildren;

	@JsonProperty("folder")
	private boolean folder;
	
	@JsonProperty("nonce")
	private int nonce;

	@JsonProperty("level")
	private int level;

	@JsonProperty("path")
	private String path;
	
	@JsonProperty("type")
	private TreeNodeType type;

	@JsonProperty("tree_node_status")
	private TreeNodeStatus status;

	@JsonProperty("last_version_uuid")
	private UUID lastVersionUuid;
	
	@JsonProperty("last_version_number")
	private int lastVersionNumber;

	@JsonProperty("progress")
	private int progress;

	@JsonProperty("processing")
	private int processing;
	
	@JsonProperty("created_by")
	private String createdBy;
	
	@JsonProperty("created_on")
	private LocalDateTime createdOn;

	@JsonProperty("lastVersion")
	private TreeNodeVersion lastVersion;

	@JsonProperty("status")
	private TreeNodeDeletedStatus deletedStatus;
	
	@Override
	public String toString() {
		return "TreeNode " + getUuid() + " " + getName();
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public void setUuid(UUID uuid) {
		this.uuid = uuid;
	}
	
	public void setVersions(List<TreeNodeVersion> versions) {
		this.versions = versions;
	}
	
	public String getName() {
		return name;
	}
	
	public List<TreeNodeVersion> getVersions() {
		return versions;
	}
	
	public UUID getUuid() {
		return uuid;
	}

	public UUID getParentNodeUuid() {
		return parentNodeUuid;
	}

	public void setParentNodeUuid(UUID parentNodeUuid) {
		this.parentNodeUuid = parentNodeUuid;
	}

	public boolean isHasLoadableChildren() {
		return hasLoadableChildren;
	}

	public void setHasLoadableChildren(boolean hasLoadableChildren) {
		this.hasLoadableChildren = hasLoadableChildren;
	}

	public int getNonce() {
		return nonce;
	}

	public void setNonce(int nonce) {
		this.nonce = nonce;
	}

	public UUID getRootNodeUuid() {
		return rootNodeUuid;
	}

	public void setRootNodeUuid(UUID rootNodeUuid) {
		this.rootNodeUuid = rootNodeUuid;
	}

	public boolean isFolder() {
		return folder;
	}

	public void setFolder(boolean folder) {
		this.folder = folder;
	}

	public int getLevel() {
		return level;
	}

	public void setLevel(int level) {
		this.level = level;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public UUID getLastVersionUuid() {
		return lastVersionUuid;
	}

	public void setLastVersionUuid(UUID lastVersionUuid) {
		this.lastVersionUuid = lastVersionUuid;
	}

	public TreeNodeVersion getLastNodeVersion() {
		return null;
	}

	public int getProgress() {
		return progress;
	}

	public void setProgress(int progress) {
		this.progress = progress;
	}

	public int getProcessing() {
		return processing;
	}

	public void setProcessing(int processing) {
		this.processing = processing;
	}

	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	public LocalDateTime getCreatedOn() {
		return createdOn;
	}

	public void setCreatedOn(LocalDateTime createdOn) {
		this.createdOn = createdOn;
	}

	public int getLastVersionNumber() {
		return lastVersionNumber;
	}

	public void setLastVersionNumber(int lastVersionNumber) {
		this.lastVersionNumber = lastVersionNumber;
	}

	public TreeNodeDeletedStatus getDeletedStatus() {
		return deletedStatus;
	}

	public void setDeletedStatus(TreeNodeDeletedStatus deletedStatus) {
		this.deletedStatus = deletedStatus;
	}

	public List<TreeNodeError> getErrors() {
		return errors;
	}

	public void setErrors(List<TreeNodeError> errors) {
		this.errors = errors;
	}
}