package nl.bimbase.bimworks.client;

import java.util.UUID;

import com.fasterxml.jackson.databind.node.ObjectNode;

import nl.bimbase.bimworks.api.geometry.GeoReference;
import nl.sascom.backplanepublic.common.Request;

public class GisApi {

	private final BimWorksClient bimWorksClient;

	public GisApi(BimWorksClient bimWorksClient) {
		this.bimWorksClient = bimWorksClient;
	}
	
	public GeoReference getGeoReference(UUID versionUuid) throws BimWorksException {
		Request request = bimWorksClient.createRequest();
		request.setTaskName("GetGeoReference");
		request.put("version_uuid", versionUuid.toString());
		return BimWorksClient.OBJECT_MAPPER.convertValue(bimWorksClient.executeAsyncTask(request), GeoReference.class);
	}

	public void setGeoReference(UUID versionUuid, GeoReference geoReference) throws BimWorksException {
		Request request = bimWorksClient.createRequest();
		request.setTaskName("SetGeoReference");
		request.put("version_uuid", versionUuid.toString());
		request.set("geo_reference", BimWorksClient.OBJECT_MAPPER.convertValue(geoReference, ObjectNode.class));
		bimWorksClient.executeAsyncTask(request);
	}
}
