/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common.utils;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import nl.sascom.backplanepublic.common.utils.Holder;

public class CountDownHolder<T>
extends Holder<T>
implements Future<T> {
    private final CountDownLatch countDownLatch = new CountDownLatch(1);

    @Override
    public T get() {
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return super.get();
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException {
        if (!this.countDownLatch.await(l, timeUnit)) {
            throw new InterruptedException("Not really interrupted, but countdown did not reach 0 within time (" + l + " " + timeUnit + ")");
        }
        return super.get();
    }

    @Override
    public void set(T t) {
        super.set(t);
        this.countDownLatch.countDown();
    }

    @Override
    public boolean cancel(boolean bl) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

