/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import nl.sascom.backplanepublic.common.StreamClosedException;
import nl.sascom.backplanepublic.common.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamReadingByteSource
extends ByteSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamReadingByteSource.class);
    private StreamSource streamSource;

    public StreamReadingByteSource(StreamSource streamSource) {
        this.streamSource = streamSource;
    }

    public InputStream openStream() throws IOException {
        return new InputStream(){
            private long readPosition;

            @Override
            public int read() throws IOException {
                return 0;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                long l = StreamReadingByteSource.this.streamSource.getWritePosition();
                int n3 = (int)(l - this.readPosition);
                int n4 = Math.min(n2, n3);
                while (n4 == 0) {
                    if (StreamReadingByteSource.this.streamSource.writingIsDone()) {
                        return -1;
                    }
                    try {
                        CountDownLatch countDownLatch = new CountDownLatch(1);
                        StreamReadingByteSource.this.streamSource.registerWriteLatch(countDownLatch, l);
                        if (!countDownLatch.await(600L, TimeUnit.SECONDS)) {
                            throw new StreamClosedException("Did not receive any new data for 60 seconds (" + StreamReadingByteSource.this.streamSource.getWritePosition() + ", " + this.readPosition + ")");
                        }
                        if (!StreamReadingByteSource.this.streamSource.isOpen()) {
                            throw new StreamClosedException("Upload interrupted");
                        }
                        StreamReadingByteSource.this.streamSource.unregisterWriteLatch(countDownLatch);
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.error("", (Throwable)interruptedException);
                    }
                    l = StreamReadingByteSource.this.streamSource.getWritePosition();
                    n3 = (int)(l - this.readPosition);
                    n4 = Math.min(n2, n3);
                }
                int n5 = StreamReadingByteSource.this.streamSource.read(this.readPosition, byArray, n, n4);
                if (n5 == -1) {
                    if (StreamReadingByteSource.this.streamSource.writingIsDone()) {
                        return -1;
                    }
                    throw new IOException("Got -1, but not done yet");
                }
                this.readPosition += (long)n5;
                return n5;
            }
        };
    }
}

