/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.client.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import nl.sascom.backplanepublic.client.NodeClient;
import nl.sascom.backplanepublic.client.auth.Auth;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.NodeClientException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuth
implements Auth {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAuth.class);
    private String username;
    private String token;

    public String getToken() {
        return this.token;
    }

    public void setToken(String string) {
        this.token = string;
    }

    @Override
    public void authenticate(NodeClient nodeClient) throws NodeClientException {
        Request request = nodeClient.createRequest();
        request.setProject("BackplaneServer");
        request.setTaskName("Login");
        request.setSync(true);
        ObjectNode objectNode = request.createObject();
        objectNode.put("username", this.getUsername());
        objectNode.put("token", this.token);
        request.setInput((JsonNode)objectNode);
        try {
            Response response = nodeClient.executeSync(request);
            if (response.getOutput() == null || !response.getOutput().has("auth")) {
                throw new NodeClientException("No auth in response to login call");
            }
            ObjectNode objectNode2 = (ObjectNode)response.getOutput().get("auth");
            nodeClient.connectAsync(objectNode2);
        }
        catch (IOException iOException) {
            LOGGER.error("", (Throwable)iOException);
        }
        catch (ExecuteException executeException) {
            LOGGER.error("", (Throwable)executeException);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }
}

