/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import nl.bimbase.bimworks.client.BimWorksClient;
import nl.bimbase.bimworks.client.BimWorksException;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.NodeClientException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;

public class AuthApi {
    private final BimWorksClient bimWorksClient;

    public AuthApi(BimWorksClient bimWorksClient) {
        this.bimWorksClient = bimWorksClient;
    }

    public ObjectNode loginWithUsernamePassword(String string, String string2) throws BimWorksException {
        try {
            return this.bimWorksClient.getNodeClient().loginApp(string, string2);
        }
        catch (NodeClientException nodeClientException) {
            throw new BimWorksException(nodeClientException);
        }
    }

    public void loginWithApiToken(String string) throws BimWorksException {
        Request request = this.bimWorksClient.getNodeClient().createRequest();
        request.setProject("BimRepository");
        request.setTaskName("LoginWithApiToken");
        ObjectNode objectNode = request.createObject();
        objectNode.put("token", string);
        request.setInput((JsonNode)objectNode);
        try {
            Response response = this.bimWorksClient.getNodeClient().executeSync(request, 10L, TimeUnit.SECONDS);
            if (response.getOutput() == null || !response.getOutput().has("auth")) {
                throw new BimWorksException("No auth in response to login call " + (response.getErrorNode() != null ? response.getErrorNode().toString() : "") + response);
            }
            ObjectNode objectNode2 = (ObjectNode)response.getOutput().get("auth");
            this.bimWorksClient.getNodeClient().setAuth(objectNode2);
            this.bimWorksClient.getNodeClient().getNodeTransport().connectAsync(objectNode2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }

    public void loginAnonymous() throws BimWorksException {
        Request request = this.bimWorksClient.getNodeClient().createRequest();
        request.setProject("BimRepository");
        request.setTaskName("LoginAnonymous");
        try {
            Response response = this.bimWorksClient.getNodeClient().executeSync(request, 10L, TimeUnit.SECONDS);
            if (response.getOutput() == null || !response.getOutput().has("auth")) {
                throw new BimWorksException("No auth in response to login call " + (response.getErrorNode() != null ? response.getErrorNode().toString() : "") + response);
            }
            ObjectNode objectNode = (ObjectNode)response.getOutput().get("auth");
            this.bimWorksClient.getNodeClient().setAuth(objectNode);
            this.bimWorksClient.getNodeClient().getNodeTransport().connectAsync(objectNode);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }
}

