package nl.bimbase.bimworks.client;

import java.time.LocalDateTime;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import nl.bimbase.bimworks.NodeVersionDeletedStatus;
import nl.bimbase.bimworks.actions.Discipline;
import nl.bimbase.bimworks.api.geometry.GeoReference;

public class TreeNodeVersion {

	@JsonProperty("uuid")
	private UUID uuid;
	
	@JsonProperty("node_uuid")
	private UUID nodeUuid;

	@JsonProperty("version")
	private int version;
	
	@JsonProperty("metadata")
	private JsonNode metadata;

	@JsonProperty("node_name")
	private String nodeName;

	@JsonProperty("created_on")
	private LocalDateTime createdOn;
	
	@JsonProperty("created_by")
	private String createdBy;
	
	@JsonProperty("status")
	private TreeNodeVersionStatus status;
	
	@JsonProperty("model_uuid")
	private UUID modelUuid;
	
	@JsonProperty("indexedmodel_uuid")
	private UUID indexedModelUuid;
	
	@JsonProperty("geo_reference")
	private GeoReference geoReference;

	@JsonProperty("discipline")
	private Discipline discipline;
	
	@JsonProperty("im_metadata")
	private ObjectNode indexedModelMetaData;
	
	@JsonProperty("deleted_status")
	private NodeVersionDeletedStatus deletedStatus;

	public UUID getUuid() {
		return uuid;
	}
	
	public void setUuid(UUID uuid) {
		this.uuid = uuid;
	}

	public UUID getNodeUuid() {
		return nodeUuid;
	}

	public void setNodeUuid(UUID nodeUuid) {
		this.nodeUuid = nodeUuid;
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}

	public JsonNode getMetadata() {
		return metadata;
	}

	public void setMetadata(JsonNode metadata) {
		this.metadata = metadata;
	}

	public String getNodeName() {
		return nodeName;
	}

	public void setNodeName(String nodeName) {
		this.nodeName = nodeName;
	}

	public LocalDateTime getCreatedOn() {
		return createdOn;
	}

	public void setCreatedOn(LocalDateTime createdOn) {
		this.createdOn = createdOn;
	}

	public UUID getModelUuid() {
		return modelUuid;
	}

	public void setModelUuid(UUID modelUuid) {
		this.modelUuid = modelUuid;
	}

	public UUID getIndexedModelUuid() {
		return indexedModelUuid;
	}

	public void setIndexedModelUuid(UUID indexedModelUuid) {
		this.indexedModelUuid = indexedModelUuid;
	}

	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	public ObjectNode getIndexedModelMetaData() {
		return indexedModelMetaData;
	}

	public void setIndexedModelMetaData(ObjectNode indexedModelMetaData) {
		this.indexedModelMetaData = indexedModelMetaData;
	}

	public NodeVersionDeletedStatus getDeletedStatus() {
		return deletedStatus;
	}

	public void setDeletedStatus(NodeVersionDeletedStatus deletedStatus) {
		this.deletedStatus = deletedStatus;
	}
}