package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import nl.sascom.backplanepublic.common.Response;

public class PropertyQuery implements CompareQuery {

	private String propertySetName;
	private String propertyName;
	private Operator operator;
	private JsonNode value;

	public PropertyQuery(String propertySetName, String propertyName, Operator operator, JsonNode value) {
		this.propertySetName = propertySetName;
		this.propertyName = propertyName;
		this.operator = operator;
		this.value = value;
	}
	
	public Operator getOperator() {
		return operator;
	}
	
	@Override
	public String getName() {
		return propertyName;
	}
	
	public String getPropertyName() {
		return propertyName;
	}
	
	public String getPropertySetName() {
		return propertySetName;
	}
	
	public JsonNode getValue() {
		return value;
	}
	
	public ObjectNode toJson() {
		ObjectNode objectNode = Response.createObject();
		objectNode.put("propertySetName", propertySetName);
		objectNode.put("name", propertyName);
		objectNode.set("operator", operator.toJson());
		if (value != null) {
			objectNode.set("value", value);
		}
		return objectNode;
	}
}
