package nl.bimbase.bimworks.client;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;

public enum Operator {
	EQUALS("="),
	LESS_THAN("<"),
	GREATER_THAN(">"),
	LESS_THAN_OR_EQUALS("<="),
	GREATER_THAN_OR_EQUALS(">="), 
	EXISTS("");

	private String symbol;
	
	private static final Map<String, Operator> SYMBOL_MAP = new HashMap<>();
	
	static {
		for (Operator operator : values()) {
			SYMBOL_MAP.put(operator.symbol, operator);
		}
	}
	
	static Operator bySymbol(String symbol) {
		return SYMBOL_MAP.get(symbol);
	}
	
	Operator(String symbol) {
		this.symbol = symbol;
	}
	
	JsonNode toJson() {
		return TextNode.valueOf(symbol);
	}
}
