/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Normalize {
    private Normalize() {
    }

    private static boolean isTokenSeparator(char letter) {
        switch (letter) {
            case ' ': 
            case '-': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static String brand(String brand) {
        if (brand.length() <= 3) {
            return brand.toUpperCase(Locale.ENGLISH);
        }
        StringBuilder sb = new StringBuilder(brand.length());
        char[] nameChars = brand.toCharArray();
        StringBuilder wordBuilder = new StringBuilder(brand.length());
        int lowerChars = 0;
        boolean wordHasNumbers = false;
        for (int i = 0; i < nameChars.length; ++i) {
            char thisChar = nameChars[i];
            if (Character.isDigit(thisChar)) {
                wordHasNumbers = true;
            }
            if (Normalize.isTokenSeparator(thisChar)) {
                if (wordBuilder.length() <= 3 || wordHasNumbers) {
                    sb.append(wordBuilder.toString().toUpperCase(Locale.ENGLISH));
                } else {
                    sb.append((CharSequence)wordBuilder);
                }
                wordBuilder.setLength(0);
                lowerChars = 0;
                wordHasNumbers = false;
                sb.append(thisChar);
                continue;
            }
            if (wordBuilder.length() == 0) {
                wordBuilder.append(Character.toUpperCase(thisChar));
            } else {
                boolean isUpperCase = Character.isUpperCase(thisChar);
                if (isUpperCase) {
                    if (lowerChars >= 3) {
                        wordBuilder.append(thisChar);
                    } else {
                        wordBuilder.append(Character.toLowerCase(thisChar));
                    }
                    lowerChars = 0;
                } else {
                    wordBuilder.append(Character.toLowerCase(thisChar));
                    ++lowerChars;
                }
            }
            if (i != nameChars.length - 1) continue;
            if (wordBuilder.length() <= 3 || wordHasNumbers) {
                sb.append(wordBuilder.toString().toUpperCase(Locale.ENGLISH));
            } else {
                sb.append((CharSequence)wordBuilder);
            }
            wordBuilder.setLength(0);
            lowerChars = 0;
            wordHasNumbers = false;
        }
        return sb.toString();
    }

    public static String cleanupDeviceBrandName(String deviceBrand, String deviceName) {
        String lowerDeviceBrand = deviceBrand.toLowerCase(Locale.ENGLISH);
        deviceName = deviceName.replaceAll("_", " ");
        deviceName = deviceName.replaceAll("- +", "-");
        deviceName = deviceName.replaceAll(" +-", "-");
        String lowerDeviceName = (deviceName = deviceName.replaceAll(" +", " ")).toLowerCase(Locale.ENGLISH);
        if (lowerDeviceName.startsWith(lowerDeviceBrand)) {
            deviceName = deviceName.replaceAll("_", " ");
            deviceName = deviceName.replaceAll("(?i)^" + Pattern.quote(deviceBrand) + "([^ ].*)$", Matcher.quoteReplacement(deviceBrand) + " $1");
            deviceName = deviceName.replaceAll("( -| )+", " ");
        } else {
            deviceName = deviceBrand + ' ' + deviceName;
        }
        String result = Normalize.brand(deviceName);
        if (result.contains("I")) {
            result = result.replace("Ipad", "iPad").replace("Ipod", "iPod").replace("Iphone", "iPhone").replace("IOS ", "iOS ");
        }
        return result;
    }

    public static String email(String email) {
        String cleaned = email;
        cleaned = cleaned.replaceAll("\\[at]", "@");
        cleaned = cleaned.replaceAll("\\[\\\\xc3\\\\xa07]", "@");
        cleaned = cleaned.replaceAll("\\[dot]", ".");
        cleaned = cleaned.replaceAll("\\\\", " ");
        cleaned = cleaned.replaceAll(" at ", "@");
        cleaned = cleaned.replaceAll("dot", ".");
        cleaned = cleaned.replaceAll(" dash ", "-");
        cleaned = cleaned.replaceAll(" ", "");
        return cleaned;
    }
}

