/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.annonate;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.annonate.UserAgentAnnotationMapper;
import nl.basjes.parse.useragent.annonate.YauaaField;
import nl.basjes.shaded.org.springframework.core.GenericTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentAnnotationAnalyzer<T> {
    private UserAgentAnnotationMapper<T> mapper = null;
    private UserAgentAnalyzer userAgentAnalyzer = null;
    private static final Logger LOG = LoggerFactory.getLogger(UserAgentAnnotationAnalyzer.class);
    private final Map<String, List<Method>> fieldSetters = new HashMap<String, List<Method>>();

    public void initialize(UserAgentAnnotationMapper<T> theMapper) {
        this.mapper = theMapper;
        if (this.mapper == null) {
            throw new InvalidParserConfigurationException("The mapper instance is null.");
        }
        Class<?> classOfT = GenericTypeResolver.resolveTypeArguments(this.mapper.getClass(), UserAgentAnnotationMapper.class)[0];
        if (classOfT == null) {
            throw new InvalidParserConfigurationException("Couldn't find the used annotation.");
        }
        for (Method method : this.mapper.getClass().getDeclaredMethods()) {
            YauaaField field = method.getAnnotation(YauaaField.class);
            if (field == null) continue;
            Class<?> returnType = method.getReturnType();
            Class<?>[] parameters = method.getParameterTypes();
            if (returnType.getCanonicalName().equals("void") && parameters.length == 2 && parameters[0] == classOfT && parameters[1] == String.class) {
                if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(classOfT.getModifiers())) {
                    throw new InvalidParserConfigurationException("Method annotated with YauaaField is not public: " + method.getName());
                }
                if (method.getDeclaringClass().isAnonymousClass()) {
                    String methodName = method.getReturnType().getName() + " " + method.getName() + "(" + parameters[0].getSimpleName() + " ," + parameters[1].getSimpleName() + ");";
                    LOG.warn("Trying to make anonymous {} {} accessible.", method.getDeclaringClass(), (Object)methodName);
                    method.setAccessible(true);
                }
                for (String fieldName : field.value()) {
                    List methods = this.fieldSetters.computeIfAbsent(fieldName, k -> new ArrayList());
                    methods.add(method);
                }
                continue;
            }
            throw new InvalidParserConfigurationException("In class [" + method.getDeclaringClass() + "] the method [" + method.getName() + "] has been annotated with YauaaField but it has the wrong method signature. It must look like [ public void " + method.getName() + "(" + classOfT.getSimpleName() + " record, String value) ]");
        }
        if (this.fieldSetters.isEmpty()) {
            throw new InvalidParserConfigurationException("You MUST specify at least 1 field to extract.");
        }
        UserAgentAnalyzer.Builder builder = UserAgentAnalyzer.newBuilder();
        builder.hideMatcherLoadStats();
        if (!this.fieldSetters.isEmpty()) {
            builder.withFields(this.fieldSetters.keySet());
        }
        this.userAgentAnalyzer = builder.build();
    }

    public T map(T record) {
        if (record == null) {
            return null;
        }
        if (this.mapper == null) {
            throw new InvalidParserConfigurationException("The mapper instance is null.");
        }
        UserAgent userAgent = this.userAgentAnalyzer.parse(this.mapper.getUserAgentString(record));
        for (Map.Entry<String, List<Method>> fieldSetter : this.fieldSetters.entrySet()) {
            String value = userAgent.getValue(fieldSetter.getKey());
            for (Method method : fieldSetter.getValue()) {
                try {
                    method.invoke(this.mapper, record, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new InvalidParserConfigurationException("Couldn't call the requested setter", e);
                }
            }
        }
        return record;
    }
}

