/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.geoip;

import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.Subdivision;
import java.io.IOException;
import java.net.InetAddress;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.httpdlog.dissectors.geoip.GeoIPCountryDissector;

public class GeoIPCityDissector
extends GeoIPCountryDissector {
    private boolean wantSubdivisionName = false;
    private boolean wantSubdivisionIso = false;
    private boolean wantAnySubdivision = false;
    private boolean wantCityName = false;
    private boolean wantCityConfidence = false;
    private boolean wantCityGeoNameId = false;
    private boolean wantAnyCity = false;
    private boolean wantPostalCode = false;
    private boolean wantPostalConfidence = false;
    private boolean wantAnyPostal = false;
    private boolean wantLocationLatitude = false;
    private boolean wantLocationLongitude = false;
    private boolean wantLocationTimezone = false;
    private boolean wantLocationAccuracyRadius = false;
    private boolean wantAnyLocation = false;

    public GeoIPCityDissector() {
    }

    public GeoIPCityDissector(String databaseFileName) {
        super(databaseFileName);
    }

    @Override
    public List<String> getPossibleOutput() {
        List<String> result = super.getPossibleOutput();
        result.add("STRING:subdivision.name");
        result.add("STRING:subdivision.iso");
        result.add("STRING:city.name");
        result.add("NUMBER:city.confidence");
        result.add("NUMBER:city.geonameid");
        result.add("STRING:postal.code");
        result.add("NUMBER:postal.confidence");
        result.add("STRING:location.latitude");
        result.add("STRING:location.longitude");
        result.add("STRING:location.timezone");
        result.add("NUMBER:location.accuracyradius");
        return result;
    }

    @Override
    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name;
        EnumSet<Casts> result = super.prepareForDissect(inputname, outputname);
        if (!result.isEmpty()) {
            return result;
        }
        switch (name = this.extractFieldName(inputname, outputname)) {
            case "subdivision.name": {
                this.wantSubdivisionName = true;
                this.wantAnySubdivision = true;
                return Casts.STRING_ONLY;
            }
            case "subdivision.iso": {
                this.wantSubdivisionIso = true;
                this.wantAnySubdivision = true;
                return Casts.STRING_ONLY;
            }
            case "city.name": {
                this.wantCityName = true;
                this.wantAnyCity = true;
                return Casts.STRING_ONLY;
            }
            case "city.confidence": {
                this.wantCityConfidence = true;
                this.wantAnyCity = true;
                return Casts.STRING_OR_LONG;
            }
            case "city.geonameid": {
                this.wantCityGeoNameId = true;
                this.wantAnyCity = true;
                return Casts.STRING_OR_LONG;
            }
            case "postal.code": {
                this.wantPostalCode = true;
                this.wantAnyPostal = true;
                return Casts.STRING_ONLY;
            }
            case "postal.confidence": {
                this.wantPostalConfidence = true;
                this.wantAnyPostal = true;
                return Casts.STRING_OR_LONG;
            }
            case "location.latitude": {
                this.wantLocationLatitude = true;
                this.wantAnyLocation = true;
                return Casts.STRING_OR_DOUBLE;
            }
            case "location.longitude": {
                this.wantLocationLongitude = true;
                this.wantAnyLocation = true;
                return Casts.STRING_OR_DOUBLE;
            }
            case "location.accuracyradius": {
                this.wantLocationAccuracyRadius = true;
                this.wantAnyLocation = true;
                return Casts.STRING_OR_LONG;
            }
            case "location.timezone": {
                this.wantLocationTimezone = true;
                this.wantAnyLocation = true;
                return Casts.STRING_ONLY;
            }
        }
        return Casts.NO_CASTS;
    }

    @Override
    public void dissect(Parsable<?> parsable, String inputname, InetAddress ipAddress) throws DissectionFailure {
        CityResponse response;
        try {
            response = this.reader.city(ipAddress);
        }
        catch (GeoIp2Exception | IOException e) {
            return;
        }
        this.extractCityResponseFields(parsable, inputname, response);
    }

    @Override
    protected void extractCityResponseFields(Parsable<?> parsable, String inputname, CityResponse response) throws DissectionFailure {
        super.extractCityResponseFields(parsable, inputname, response);
        if (this.wantAnySubdivision) {
            this.extractSubdivisionFields(parsable, inputname, response.mostSpecificSubdivision());
        }
        if (this.wantAnyCity) {
            this.extractCityFields(parsable, inputname, response.city());
        }
        if (this.wantAnyPostal) {
            this.extractPostalFields(parsable, inputname, response.postal());
        }
        if (this.wantAnyLocation) {
            this.extractLocationFields(parsable, inputname, response.location());
        }
    }

    protected void extractSubdivisionFields(Parsable<?> parsable, String inputname, Subdivision subdivision) throws DissectionFailure {
        if (subdivision != null) {
            if (this.wantSubdivisionName) {
                parsable.addDissection(inputname, "STRING", "subdivision.name", subdivision.name());
            }
            if (this.wantSubdivisionIso) {
                parsable.addDissection(inputname, "STRING", "subdivision.iso", subdivision.isoCode());
            }
        }
    }

    protected void extractCityFields(Parsable<?> parsable, String inputname, City city) throws DissectionFailure {
        if (city != null) {
            if (this.wantCityName) {
                parsable.addDissection(inputname, "STRING", "city.name", city.name());
            }
            if (this.wantCityConfidence) {
                parsable.addDissection(inputname, "NUMBER", "city.confidence", city.confidence());
            }
            if (this.wantCityGeoNameId) {
                parsable.addDissection(inputname, "NUMBER", "city.geonameid", city.geonameId());
            }
        }
    }

    protected void extractPostalFields(Parsable<?> parsable, String inputname, Postal postal) throws DissectionFailure {
        if (postal != null) {
            if (this.wantPostalCode) {
                parsable.addDissection(inputname, "STRING", "postal.code", postal.code());
            }
            if (this.wantPostalConfidence) {
                parsable.addDissection(inputname, "NUMBER", "postal.confidence", postal.confidence());
            }
        }
    }

    protected void extractLocationFields(Parsable<?> parsable, String inputname, Location location) throws DissectionFailure {
        if (location != null) {
            if (this.wantLocationLatitude) {
                parsable.addDissection(inputname, "STRING", "location.latitude", location.latitude());
            }
            if (this.wantLocationLongitude) {
                parsable.addDissection(inputname, "STRING", "location.longitude", location.longitude());
            }
            if (this.wantLocationTimezone) {
                parsable.addDissection(inputname, "STRING", "location.timezone", location.timeZone());
            }
            if (this.wantLocationAccuracyRadius) {
                parsable.addDissection(inputname, "NUMBER", "location.accuracyradius", location.accuracyRadius());
            }
        }
    }
}

