/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.nginxmodules;

import java.util.ArrayList;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.httpdlog.dissectors.nginxmodules.NginxModule;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.NamedTokenParser;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenParser;

public class VariousModule
implements NginxModule {
    private static final String PREFIX = "nginxmodule";

    @Override
    public List<TokenParser> getTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>(60);
        parsers.add(new TokenParser("$secure_link", "nginxmodule.secure_link.status", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$session_log_id", "nginxmodule.session_log.id", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$slice_range", "nginxmodule.slice_range", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$proxy_host", "nginxmodule.proxy.host", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$proxy_port", "nginxmodule.proxy.port", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$proxy_add_x_forwarded_for", "nginxmodule.proxy.add_x_forwarded_for", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$uid_got", "nginxmodule.userid.uid_got", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$uid_reset", "nginxmodule.userid.uid_reset", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$uid_set", "nginxmodule.userid.uid_set", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$modern_browser", "nginxmodule.browser.modern", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ancient_browser", "nginxmodule.browser.ancient", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$msie", "nginxmodule.browser.msie", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$connections_active", "nginxmodule.stub_status.connections.active", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$connections_reading", "nginxmodule.stub_status.connections.reading", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$connections_writing", "nginxmodule.stub_status.connections.writing", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$connections_waiting", "nginxmodule.stub_status.connections.waiting", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$date_local", "nginxmodule.date.local", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$date_gmt", "nginxmodule.date.gmt", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$fastcgi_script_name", "nginxmodule.fastcgi.script_name", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$fastcgi_path_info", "nginxmodule.fastcgi.path_info", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$gzip_ratio", "nginxmodule.gzip.ratio", "STRING", Casts.STRING_ONLY, "[0-9]+(?:\\.[0-9]+)?"));
        parsers.add(new TokenParser("$spdy", "nginxmodule.spdy.version", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$spdy_request_priority", "nginxmodule.spdy.request_priority", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$http2", "nginxmodule.http2.negotiated_protocol", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$invalid_referer", "nginxmodule.referer.invalid", "STRING", Casts.STRING_ONLY, "1?"));
        parsers.add(new NamedTokenParser("\\$jwt_header_([a-z0-9\\-_]*)", "nginxmodule.jwt.header.", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new NamedTokenParser("\\$jwt_claim_([a-z0-9\\-_]*)", "nginxmodule.jwt.claim.", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$memcached_key", "nginxmodule.memcached.key", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$realip_remote_addr", "nginxmodule.realip.remote_addr", "IP", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$realip_remote_port", "nginxmodule.realip.remote_port", "PORT", Casts.STRING_OR_LONG, ".*?"));
        return parsers;
    }
}

