/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.geoip;

import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AbstractCountryResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.httpdlog.dissectors.geoip.AbstractGeoIPDissector;

public class GeoIPCountryDissector
extends AbstractGeoIPDissector {
    private boolean wantContinentName = false;
    private boolean wantContinentCode = false;
    private boolean wantAnyContinent = false;
    private boolean wantCountryName = false;
    private boolean wantCountryIso = false;
    private boolean wantCountryGetConfidence = false;
    private boolean wantCountryIsInEuropeanUnion = false;
    private boolean wantAnyCountry = false;

    public GeoIPCountryDissector() {
    }

    public GeoIPCountryDissector(String databaseFileName) {
        super(databaseFileName);
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("STRING:continent.name");
        result.add("STRING:continent.code");
        result.add("STRING:country.name");
        result.add("STRING:country.iso");
        result.add("NUMBER:country.getconfidence");
        result.add("BOOLEAN:country.isineuropeanunion");
        return result;
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name;
        switch (name = this.extractFieldName(inputname, outputname)) {
            case "continent.name": {
                this.wantContinentName = true;
                this.wantAnyContinent = true;
                return Casts.STRING_ONLY;
            }
            case "continent.code": {
                this.wantContinentCode = true;
                this.wantAnyContinent = true;
                return Casts.STRING_ONLY;
            }
            case "country.name": {
                this.wantCountryName = true;
                this.wantAnyCountry = true;
                return Casts.STRING_ONLY;
            }
            case "country.iso": {
                this.wantCountryIso = true;
                this.wantAnyCountry = true;
                return Casts.STRING_ONLY;
            }
            case "country.getconfidence": {
                this.wantCountryGetConfidence = true;
                this.wantAnyCountry = true;
                return Casts.STRING_OR_LONG;
            }
            case "country.isineuropeanunion": {
                this.wantCountryIsInEuropeanUnion = true;
                this.wantAnyCountry = true;
                return Casts.STRING_OR_LONG;
            }
        }
        return null;
    }

    @Override
    public void dissect(Parsable<?> parsable, String inputname, InetAddress ipAddress) throws DissectionFailure {
        CountryResponse response;
        try {
            response = this.reader.country(ipAddress);
        }
        catch (GeoIp2Exception | IOException e) {
            return;
        }
        if (response == null) {
            return;
        }
        this.extractCountryFields(parsable, inputname, (AbstractCountryResponse)response);
    }

    protected void extractCountryFields(Parsable<?> parsable, String inputname, AbstractCountryResponse response) throws DissectionFailure {
        Country country;
        Continent continent;
        if (this.wantAnyContinent && (continent = response.getContinent()) != null) {
            if (this.wantContinentName) {
                parsable.addDissection(inputname, "STRING", "continent.name", continent.getName());
            }
            if (this.wantContinentCode) {
                parsable.addDissection(inputname, "STRING", "continent.code", continent.getCode());
            }
        }
        if (this.wantAnyCountry && (country = response.getCountry()) != null) {
            if (this.wantCountryName) {
                parsable.addDissection(inputname, "STRING", "country.name", country.getName());
            }
            if (this.wantCountryIso) {
                parsable.addDissection(inputname, "STRING", "country.iso", country.getIsoCode());
            }
            if (this.wantCountryGetConfidence) {
                parsable.addDissection(inputname, "NUMBER", "country.getconfidence", country.getConfidence());
            }
            if (this.wantCountryIsInEuropeanUnion) {
                parsable.addDissection(inputname, "BOOLEAN", "country.isineuropeanunion", country.isInEuropeanUnion() ? 1L : 0L);
            }
        }
    }
}

