/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.httpdlog.dissectors.StrfTimeToDateTimeFormatter;
import nl.basjes.parse.httpdlog.dissectors.TimeStampDissector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrfTimeStampDissector
extends Dissector {
    private static final Logger LOG = LoggerFactory.getLogger(StrfTimeStampDissector.class);
    private TimeStampDissector timeStampDissector = new TimeStampDissector();
    private String strfDateTimePattern = null;
    private String inputType = "TIME.?????";

    public void setDateTimePattern(String newDateTimePattern) {
        if (newDateTimePattern == null) {
            this.timeStampDissector.setDateTimePattern("");
            return;
        }
        if (newDateTimePattern.equals(this.strfDateTimePattern)) {
            return;
        }
        this.strfDateTimePattern = newDateTimePattern;
        this.timeStampDissector.setFormatter(StrfTimeToDateTimeFormatter.convert(newDateTimePattern));
    }

    public boolean initializeFromSettingsParameter(String settings) {
        this.setDateTimePattern(settings);
        return true;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField field = parsable.getParsableField(this.inputType, inputname);
        this.timeStampDissector.dissect(field, parsable, inputname);
    }

    public String getInputType() {
        return this.inputType;
    }

    public List<String> getPossibleOutput() {
        return this.timeStampDissector.getPossibleOutput();
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        return this.timeStampDissector.prepareForDissect(inputname, outputname);
    }

    public void prepareForRun() throws InvalidDissectorException {
        this.timeStampDissector.prepareForRun();
    }

    protected void initializeNewInstance(Dissector newInstance) throws InvalidDissectorException {
        StrfTimeStampDissector newStrfTimeStampDissector = (StrfTimeStampDissector)newInstance;
        newStrfTimeStampDissector.timeStampDissector.initializeNewInstance(newStrfTimeStampDissector.timeStampDissector);
        newStrfTimeStampDissector.setInputType(this.inputType);
        newStrfTimeStampDissector.setDateTimePattern(this.strfDateTimePattern);
    }

    public void setInputType(String newInputType) {
        this.inputType = newInputType;
    }

    public <RECORD> void createAdditionalDissectors(Parser<RECORD> parser) {
        parser.addDissector((Dissector)new LocalizedTimeDissector(this.inputType));
    }

    public static class LocalizedTimeDissector
    extends Dissector {
        String inputType = null;

        public LocalizedTimeDissector() {
        }

        public LocalizedTimeDissector(String inputType) {
            this.inputType = inputType;
        }

        public void setInputType(String newInputType) {
            this.inputType = newInputType;
        }

        public boolean initializeFromSettingsParameter(String settings) {
            this.setInputType(settings);
            return true;
        }

        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
            ParsedField field = parsable.getParsableField(this.inputType, inputname);
            parsable.addDissection(inputname, "TIME.LOCALIZEDSTRING", "", field.getValue());
        }

        public String getInputType() {
            return this.inputType;
        }

        public List<String> getPossibleOutput() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("TIME.LOCALIZEDSTRING:");
            return result;
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return Casts.STRING_ONLY;
        }

        public void prepareForRun() throws InvalidDissectorException {
        }

        protected void initializeNewInstance(Dissector newInstance) throws InvalidDissectorException {
            newInstance.setInputType(this.inputType);
        }
    }
}

