/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.tokenformat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.Token;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenParser;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenSorterByStartPos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TokenFormatDissector
extends Dissector {
    private static final Logger LOG = LoggerFactory.getLogger(TokenFormatDissector.class);
    private String logFormat = null;
    private List<String> logFormatNames = null;
    private List<String> logFormatTypes = null;
    private String logFormatRegEx = null;
    private Pattern logFormatPattern = null;
    private boolean isUsable = false;
    private List<Token> logFormatTokens;
    private List<String> outputTypes;
    public static final String FIXED_STRING_TYPE = "NONE";
    private final Set<String> requestedFields = new HashSet<String>(16);
    private String inputType = null;

    public TokenFormatDissector(String logFormat) {
        this.setLogFormat(logFormat);
    }

    public TokenFormatDissector() {
    }

    public boolean initializeFromSettingsParameter(String settings) {
        this.setLogFormat(this.logFormat);
        return true;
    }

    protected void initializeNewInstance(Dissector newInstance) {
        if (newInstance instanceof TokenFormatDissector) {
            ((TokenFormatDissector)newInstance).setLogFormat(this.logFormat);
        } else {
            LOG.error("============================== WTF == {}", (Object)newInstance.getClass().getCanonicalName());
        }
    }

    public void setLogFormat(String logformat) {
        this.logFormat = logformat;
        this.logFormatTokens = this.parseTokenLogFileDefinition(this.logFormat);
        this.outputTypes = new ArrayList<String>();
        for (Token token : this.logFormatTokens) {
            String type = token.getType();
            if (FIXED_STRING_TYPE.equals(type)) continue;
            this.outputTypes.add(token.getType() + ':' + token.getName());
        }
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public String getLogFormatRegEx() {
        return this.logFormatRegEx;
    }

    public EnumSet<Casts> prepareForDissect(String inputName, String outputName) {
        this.requestedFields.add(outputName);
        for (Token token : this.logFormatTokens) {
            if (!outputName.equals(token.getName())) continue;
            return token.getCasts();
        }
        return Casts.STRING_ONLY;
    }

    public void prepareForRun() throws InvalidDissectorException {
        StringBuilder regex = new StringBuilder(this.logFormatTokens.size() * 16);
        this.logFormatNames = new ArrayList<String>();
        this.logFormatTypes = new ArrayList<String>();
        regex.append('^');
        for (Token token : this.logFormatTokens) {
            if (FIXED_STRING_TYPE.equals(token.getType())) {
                regex.append(Pattern.quote(token.getRegex()));
                continue;
            }
            if (this.requestedFields.contains(token.getName())) {
                this.logFormatNames.add(token.getName());
                this.logFormatTypes.add(token.getType());
                regex.append("(").append(token.getRegex()).append(")");
                continue;
            }
            regex.append("(?:").append(token.getRegex()).append(")");
        }
        regex.append('$');
        this.logFormatRegEx = regex.toString();
        LOG.debug("Source logformat : {}", (Object)this.logFormat);
        LOG.debug("Used regex       : {}", (Object)this.logFormatRegEx);
        this.logFormatPattern = Pattern.compile(this.logFormatRegEx);
        this.isUsable = true;
    }

    protected void setInputType(String newInputType) {
        this.inputType = newInputType;
    }

    public String getInputType() {
        return this.inputType;
    }

    public List<String> getPossibleOutput() {
        return this.outputTypes;
    }

    public abstract String decodeExtractedValue(String var1, String var2);

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        if (!this.isUsable) {
            throw new DissectionFailure("Dissector in unusable state");
        }
        ParsedField line = parsable.getParsableField(this.inputType, inputname);
        Matcher matcher = this.logFormatPattern.matcher(line.getValue().getString());
        boolean matches = matcher.find();
        if (matches) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String matchedStr = matcher.group(i);
                String matchedName = this.logFormatNames.get(i - 1);
                String matchedType = this.logFormatTypes.get(i - 1);
                parsable.addDissection(inputname, matchedType, matchedName, this.decodeExtractedValue(matchedName, matchedStr));
            }
        } else {
            throw new DissectionFailure("The input line does not match the specified log format.Line     : " + line.getValue() + "\n" + "LogFormat: " + this.logFormat + "\n" + "RegEx    : " + this.logFormatRegEx);
        }
    }

    protected String cleanupLogFormat(String tokenLogFormat) {
        return tokenLogFormat;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<Token> parseTokenLogFileDefinition(String tokenLogFormat) {
        List<TokenParser> tokenParsers = this.createAllTokenParsers();
        ArrayList<Token> tokens = new ArrayList<Token>(50);
        String cleanedTokenLogFormat = this.cleanupLogFormat(tokenLogFormat);
        for (TokenParser tokenParser : tokenParsers) {
            List<Token> newTokens = tokenParser.getTokens(cleanedTokenLogFormat);
            if (newTokens == null) continue;
            tokens.addAll(newTokens);
        }
        Collections.sort(tokens, new TokenSorterByStartPos());
        ArrayList<Token> kickTokens = new ArrayList<Token>(50);
        Token prevToken = null;
        for (Token token : tokens) {
            block10: {
                if (prevToken == null) {
                    prevToken = token;
                    continue;
                }
                if (prevToken.getStartPos() == token.getStartPos()) {
                    if (prevToken.getPrio() < token.getPrio()) {
                        kickTokens.add(prevToken);
                        break block10;
                    } else {
                        kickTokens.add(token);
                        continue;
                    }
                }
                if (prevToken.getStartPos() + prevToken.getLength() > token.getStartPos()) {
                    kickTokens.add(token);
                    continue;
                }
            }
            prevToken = token;
        }
        tokens.removeAll(kickTokens);
        ArrayList<Token> allTokens = new ArrayList<Token>(50);
        int tokenEnd = 0;
        for (Token token : tokens) {
            int tokenBegin = token.getStartPos();
            if (tokenBegin - tokenEnd > 0) {
                String separator = cleanedTokenLogFormat.substring(tokenEnd, tokenBegin);
                Token fixedStringToken = new Token("FIXED_STRING", FIXED_STRING_TYPE, null, separator, tokenBegin, tokenBegin - tokenEnd);
                allTokens.add(fixedStringToken);
            }
            allTokens.add(token);
            tokenEnd = tokenBegin + token.getLength();
        }
        int logFormatLength = cleanedTokenLogFormat.length();
        if (tokenEnd < logFormatLength) {
            String separator = cleanedTokenLogFormat.substring(tokenEnd);
            Token fixedStringToken = new Token("FIXED_STRING", FIXED_STRING_TYPE, null, separator, tokenEnd, cleanedTokenLogFormat.length() - tokenEnd);
            allTokens.add(fixedStringToken);
        }
        return allTokens;
    }

    protected abstract List<TokenParser> createAllTokenParsers();

    public static class FixedStringTokenParser
    extends TokenParser {
        public FixedStringTokenParser(String nLogFormatToken, String nRegEx) {
            super(nLogFormatToken, "FIXED_STRING", TokenFormatDissector.FIXED_STRING_TYPE, null, nRegEx, 0);
        }

        public FixedStringTokenParser(String nLogFormatToken) {
            super(nLogFormatToken, "FIXED_STRING", TokenFormatDissector.FIXED_STRING_TYPE, null, ".*", 0);
        }
    }
}

