/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStampDissector
extends Dissector {
    private static final Logger LOG = LoggerFactory.getLogger(TimeStampDissector.class);
    private DateTimeFormatter formatter;
    private DateTimeFormatter asParsedFormatter;
    private String dateTimePattern;
    private static final String INPUT_TYPE = "TIME.STAMP";
    private boolean wantAnyAsParsed = false;
    private boolean wantAnyUTC = false;
    private boolean wantAnyTZIndependent = false;
    private boolean wantDay = false;
    private boolean wantMonthname = false;
    private boolean wantMonth = false;
    private boolean wantWeekOfWeekYear = false;
    private boolean wantWeekYear = false;
    private boolean wantYear = false;
    private boolean wantHour = false;
    private boolean wantMinute = false;
    private boolean wantSecond = false;
    private boolean wantMillisecond = false;
    private boolean wantTimezone = false;
    private boolean wantEpoch = false;
    private boolean wantDayUTC = false;
    private boolean wantMonthnameUTC = false;
    private boolean wantMonthUTC = false;
    private boolean wantWeekOfWeekYearUTC = false;
    private boolean wantWeekYearUTC = false;
    private boolean wantYearUTC = false;
    private boolean wantHourUTC = false;
    private boolean wantMinuteUTC = false;
    private boolean wantSecondUTC = false;
    private boolean wantMillisecondUTC = false;

    public TimeStampDissector() {
        this.setDateTimePattern("[dd/MMM/yyyy:HH:mm:ss ZZ]");
    }

    public TimeStampDissector(String newDateTimePattern) {
        this.setDateTimePattern(newDateTimePattern);
    }

    public boolean initializeFromSettingsParameter(String settings) {
        this.setDateTimePattern(settings);
        return true;
    }

    public void setDateTimePattern(String newDateTimePattern) {
        this.dateTimePattern = newDateTimePattern;
        this.formatter = DateTimeFormat.forPattern((String)this.dateTimePattern).withZone(DateTimeZone.UTC);
        this.asParsedFormatter = this.formatter.withOffsetParsed();
    }

    protected void initializeNewInstance(Dissector newInstance) {
        ((TimeStampDissector)newInstance).setDateTimePattern(this.dateTimePattern);
    }

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("TIME.DAY:day");
        result.add("TIME.MONTHNAME:monthname");
        result.add("TIME.MONTH:month");
        result.add("TIME.WEEK:weekofweekyear");
        result.add("TIME.YEAR:weekyear");
        result.add("TIME.YEAR:year");
        result.add("TIME.HOUR:hour");
        result.add("TIME.MINUTE:minute");
        result.add("TIME.SECOND:second");
        result.add("TIME.MILLISECOND:millisecond");
        result.add("TIME.ZONE:timezone");
        result.add("TIME.EPOCH:epoch");
        result.add("TIME.DAY:day_utc");
        result.add("TIME.MONTHNAME:monthname_utc");
        result.add("TIME.MONTH:month_utc");
        result.add("TIME.WEEK:weekofweekyear_utc");
        result.add("TIME.YEAR:weekyear_utc");
        result.add("TIME.YEAR:year_utc");
        result.add("TIME.HOUR:hour_utc");
        result.add("TIME.MINUTE:minute_utc");
        result.add("TIME.SECOND:second_utc");
        result.add("TIME.MILLISECOND:millisecond_utc");
        return result;
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name;
        switch (name = outputname.substring(inputname.length() + 1)) {
            case "day": {
                this.wantDay = true;
                return Casts.STRING_OR_LONG;
            }
            case "monthname": {
                this.wantMonthname = true;
                return Casts.STRING_ONLY;
            }
            case "month": {
                this.wantMonth = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekofweekyear": {
                this.wantWeekOfWeekYear = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekyear": {
                this.wantWeekYear = true;
                return Casts.STRING_OR_LONG;
            }
            case "year": {
                this.wantYear = true;
                return Casts.STRING_OR_LONG;
            }
            case "hour": {
                this.wantHour = true;
                return Casts.STRING_OR_LONG;
            }
            case "minute": {
                this.wantMinute = true;
                return Casts.STRING_OR_LONG;
            }
            case "second": {
                this.wantSecond = true;
                return Casts.STRING_OR_LONG;
            }
            case "millisecond": {
                this.wantMillisecond = true;
                return Casts.STRING_OR_LONG;
            }
            case "timezone": {
                this.wantTimezone = true;
                return Casts.STRING_ONLY;
            }
            case "epoch": {
                this.wantEpoch = true;
                return Casts.STRING_OR_LONG;
            }
            case "day_utc": {
                this.wantDayUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "monthname_utc": {
                this.wantMonthnameUTC = true;
                return Casts.STRING_ONLY;
            }
            case "month_utc": {
                this.wantMonthUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekofweekyear_utc": {
                this.wantWeekOfWeekYearUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekyear_utc": {
                this.wantWeekYearUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "year_utc": {
                this.wantYearUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "hour_utc": {
                this.wantHourUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "minute_utc": {
                this.wantMinuteUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "second_utc": {
                this.wantSecondUTC = true;
                return Casts.STRING_OR_LONG;
            }
            case "millisecond_utc": {
                this.wantMillisecondUTC = true;
                return Casts.STRING_OR_LONG;
            }
        }
        return null;
    }

    public void prepareForRun() {
        this.wantAnyAsParsed = this.wantDay || this.wantMonthname || this.wantMonth || this.wantWeekOfWeekYear || this.wantWeekYear || this.wantYear || this.wantHour || this.wantMinute || this.wantSecond || this.wantMillisecond;
        this.wantAnyTZIndependent = this.wantTimezone || this.wantEpoch;
        this.wantAnyUTC = this.wantDayUTC || this.wantMonthnameUTC || this.wantMonthUTC || this.wantWeekOfWeekYearUTC || this.wantWeekYearUTC || this.wantYearUTC || this.wantHourUTC || this.wantMinuteUTC || this.wantSecondUTC || this.wantMillisecondUTC;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        DateTime dateTime;
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        if (this.wantAnyAsParsed || this.wantAnyTZIndependent) {
            dateTime = this.asParsedFormatter.parseDateTime(fieldValue);
            DateTimeZone zone = dateTime.getZone();
            DateTimeFormatter asParsedWithZoneFormatter = this.asParsedFormatter.withZone(zone);
            dateTime = asParsedWithZoneFormatter.parseDateTime(fieldValue);
            if (this.wantDay) {
                parsable.addDissection(inputname, "TIME.DAY", "day", dateTime.dayOfMonth().getAsString());
            }
            if (this.wantMonthname) {
                parsable.addDissection(inputname, "TIME.MONTHNAME", "monthname", dateTime.monthOfYear().getAsText(Locale.getDefault()));
            }
            if (this.wantMonth) {
                parsable.addDissection(inputname, "TIME.MONTH", "month", dateTime.monthOfYear().getAsString());
            }
            if (this.wantWeekOfWeekYear) {
                parsable.addDissection(inputname, "TIME.WEEK", "weekofweekyear", dateTime.weekOfWeekyear().getAsString());
            }
            if (this.wantWeekYear) {
                parsable.addDissection(inputname, "TIME.YEAR", "weekyear", dateTime.weekyear().getAsString());
            }
            if (this.wantYear) {
                parsable.addDissection(inputname, "TIME.YEAR", "year", dateTime.year().getAsString());
            }
            if (this.wantHour) {
                parsable.addDissection(inputname, "TIME.HOUR", "hour", dateTime.hourOfDay().getAsString());
            }
            if (this.wantMinute) {
                parsable.addDissection(inputname, "TIME.MINUTE", "minute", dateTime.minuteOfHour().getAsString());
            }
            if (this.wantSecond) {
                parsable.addDissection(inputname, "TIME.SECOND", "second", dateTime.secondOfMinute().getAsString());
            }
            if (this.wantMillisecond) {
                parsable.addDissection(inputname, "TIME.MILLISECOND", "millisecond", dateTime.millisOfSecond().getAsString());
            }
            if (this.wantTimezone) {
                parsable.addDissection(inputname, "TIME.TIMEZONE", "timezone", dateTime.getZone().getID());
            }
            if (this.wantEpoch) {
                parsable.addDissection(inputname, "TIME.EPOCH", "epoch", Long.toString(dateTime.getMillis()));
            }
        }
        if (this.wantAnyUTC) {
            dateTime = this.formatter.parseDateTime(fieldValue);
            if (this.wantDayUTC) {
                parsable.addDissection(inputname, "TIME.DAY", "day_utc", dateTime.dayOfMonth().getAsString());
            }
            if (this.wantMonthnameUTC) {
                parsable.addDissection(inputname, "TIME.MONTHNAME", "monthname_utc", dateTime.monthOfYear().getAsText(Locale.getDefault()));
            }
            if (this.wantMonthUTC) {
                parsable.addDissection(inputname, "TIME.MONTH", "month_utc", dateTime.monthOfYear().getAsString());
            }
            if (this.wantWeekOfWeekYearUTC) {
                parsable.addDissection(inputname, "TIME.WEEK", "weekofweekyear_utc", dateTime.weekOfWeekyear().getAsString());
            }
            if (this.wantWeekYearUTC) {
                parsable.addDissection(inputname, "TIME.YEAR", "weekyear_utc", dateTime.weekyear().getAsString());
            }
            if (this.wantYearUTC) {
                parsable.addDissection(inputname, "TIME.YEAR", "year_utc", dateTime.year().getAsString());
            }
            if (this.wantHourUTC) {
                parsable.addDissection(inputname, "TIME.HOUR", "hour_utc", dateTime.hourOfDay().getAsString());
            }
            if (this.wantMinuteUTC) {
                parsable.addDissection(inputname, "TIME.MINUTE", "minute_utc", dateTime.minuteOfHour().getAsString());
            }
            if (this.wantSecondUTC) {
                parsable.addDissection(inputname, "TIME.SECOND", "second_utc", dateTime.secondOfMinute().getAsString());
            }
            if (this.wantMillisecondUTC) {
                parsable.addDissection(inputname, "TIME.MILLISECOND", "millisecond_utc", dateTime.millisOfSecond().getAsString());
            }
        }
    }
}

