/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.repo;

import java.util.List;
import javax.annotation.Nonnull;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.data.DataRepository;
import network.minter.profile.api.ProfileAddressEndpoint;
import network.minter.profile.models.ProfileAddressData;
import network.minter.profile.models.ProfileResult;
import retrofit2.Call;

public class ProfileAddressRepository
extends DataRepository<ProfileAddressEndpoint>
implements DataRepository.Configurator {
    public ProfileAddressRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Call<ProfileResult<List<ProfileAddressData>>> getAddresses() {
        ProfileAddressRepository profileAddressRepository = this;
        return ((ProfileAddressEndpoint)profileAddressRepository.getInstantService(profileAddressRepository)).getAddresses();
    }

    public Call<ProfileResult<List<ProfileAddressData>>> getAddresses(int n) {
        ProfileAddressRepository profileAddressRepository = this;
        return ((ProfileAddressEndpoint)profileAddressRepository.getInstantService(profileAddressRepository)).getAddresses(n);
    }

    public Call<ProfileResult<List<ProfileAddressData>>> getAddressesWithEncrypted() {
        ProfileAddressRepository profileAddressRepository = this;
        return ((ProfileAddressEndpoint)profileAddressRepository.getInstantService(profileAddressRepository)).getAddressesWithEncrypted();
    }

    public Call<ProfileResult<Object>> delete(String string) {
        ProfileAddressRepository profileAddressRepository = this;
        return ((ProfileAddressEndpoint)profileAddressRepository.getInstantService(profileAddressRepository)).deleteAddress(string);
    }

    public Call<ProfileResult<Object>> delete(ProfileAddressData profileAddressData) {
        return this.delete(profileAddressData.id);
    }

    public Call<ProfileResult<Object>> addAddress(ProfileAddressData profileAddressData) {
        ProfileAddressRepository profileAddressRepository = this;
        return ((ProfileAddressEndpoint)profileAddressRepository.getInstantService(profileAddressRepository)).addAddress(profileAddressData);
    }

    public Call<ProfileResult<Object>> updateAddress(ProfileAddressData profileAddressData) {
        ProfileAddressRepository profileAddressRepository = this;
        return ((ProfileAddressEndpoint)profileAddressRepository.getInstantService(profileAddressRepository)).updateAddress(profileAddressData.id, profileAddressData);
    }

    public Call<ProfileResult<Object>> setAddressMain(boolean bl, ProfileAddressData profileAddressData) {
        ProfileAddressRepository profileAddressRepository = this;
        profileAddressData.isMain = bl;
        return ((ProfileAddressEndpoint)profileAddressRepository.getInstantService(profileAddressRepository)).updateAddress(profileAddressData.id, profileAddressData);
    }

    public void configure(ApiService.Builder builder) {
        builder.authRequired(true);
    }

    @Nonnull
    protected Class<ProfileAddressEndpoint> getServiceClass() {
        return ProfileAddressEndpoint.class;
    }
}

