/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.repo;

import java.util.Map;
import javax.annotation.Nonnull;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.core.internal.helpers.CollectionsHelper;
import network.minter.profile.api.ProfileEndpoint;
import network.minter.profile.models.PasswordChangeRequest;
import network.minter.profile.models.ProfileRequestResult;
import network.minter.profile.models.ProfileResult;
import network.minter.profile.models.User;
import retrofit2.Call;

public class ProfileRepository
extends DataRepository<ProfileEndpoint>
implements DataRepository.Configurator {
    public ProfileRepository(@Nonnull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<ProfileResult<User.Data>> getProfile() {
        return ((ProfileEndpoint)this.getInstantService()).getProfile();
    }

    public Call<ProfileResult<ProfileRequestResult>> updateProfile(@Nonnull User.Data data) {
        Preconditions.checkNotNull((Object)data);
        return ((ProfileEndpoint)this.getInstantService(this)).updateProfile(data);
    }

    public Call<ProfileResult<ProfileRequestResult>> updateField(String field, String value) {
        Map data = CollectionsHelper.asMap((Object[])new String[]{field, value});
        return ((ProfileEndpoint)this.getInstantService(this)).updateProfile(data);
    }

    public Call<ProfileResult<User.Avatar>> updateAvatar(String b64) {
        return ((ProfileEndpoint)this.getInstantService(this)).updateAvatarBase64(b64);
    }

    public Call<ProfileResult<Object>> changePassword(PasswordChangeRequest data) {
        return ((ProfileEndpoint)this.getInstantService(this)).changePassword(data);
    }

    public void configure(ApiService.Builder api) {
        api.authRequired();
    }

    @Nonnull
    protected Class<ProfileEndpoint> getServiceClass() {
        return ProfileEndpoint.class;
    }
}

