/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.api;

import java.util.Map;
import network.minter.profile.models.PasswordChangeRequest;
import network.minter.profile.models.ProfileRequestResult;
import network.minter.profile.models.ProfileResult;
import network.minter.profile.models.User;
import okhttp3.MultipartBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;

public interface ProfileEndpoint {
    @GET(value="/api/v1/profile")
    public Call<ProfileResult<User.Data>> getProfile();

    @PUT(value="/api/v1/profile")
    public Call<ProfileResult<ProfileRequestResult>> updateProfile(@Body User.Data var1);

    @PUT(value="/api/v1/profile")
    @Headers(value={"Content-Type: application/json"})
    public Call<ProfileResult<ProfileRequestResult>> updateProfile(@Body Map<String, String> var1);

    @GET(value="/api/v1/profile/avatar")
    public Call<ProfileResult<User.Avatar>> getAvatar();

    @Multipart
    @POST(value="/api/v1/profile/avatar")
    public Call<ProfileResult<User.Avatar>> updateAvatarMultipart(@Part MultipartBody.Part var1);

    @FormUrlEncoded
    @POST(value="/api/v1/profile/avatar")
    public Call<ProfileResult<User.Avatar>> updateAvatarBase64(@Field(value="avatarBase64") String var1);

    @DELETE(value="/api/v1/profile/avatar")
    public Call<ProfileResult<Void>> deleteAvatar();

    @FormUrlEncoded
    @POST(value="/api/v1/profile/confirm/{id}")
    public Call<ProfileResult<Void>> confirmProfile(@Path(value="id") String var1, @Field(value="code") String var2);

    @POST(value="/api/v1/profile/password")
    public Call<ProfileResult<Object>> changePassword(@Body PasswordChangeRequest var1);
}

