/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import com.google.gson.reflect.TypeToken;
import io.reactivex.Observable;
import java.lang.reflect.Type;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.GateCoinEndpoint;
import network.minter.explorer.models.CoinItem;
import network.minter.explorer.models.GateResult;

public class GateCoinRepository
extends DataRepository<GateCoinEndpoint>
implements DataRepository.Configurator {
    public GateCoinRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Observable<GateResult<CoinItem>> getCoinInfo(String string) {
        return ((GateCoinEndpoint)this.getInstantService()).getCoinInfo(string);
    }

    public Observable<GateResult<CoinItem>> getCoinInfo(BigInteger bigInteger) {
        return ((GateCoinEndpoint)this.getInstantService()).getCoinInfoById(bigInteger.toString());
    }

    public Observable<Boolean> coinExists(BigInteger bigInteger) {
        return this.getCoinInfo(bigInteger).switchMap(gateResult -> Observable.just((Object)gateResult.isOk()));
    }

    public Observable<Boolean> coinExists(String string) {
        return this.getCoinInfo(string).switchMap(gateResult -> Observable.just((Object)gateResult.isOk()));
    }

    @Nonnull
    protected Class<GateCoinEndpoint> getServiceClass() {
        return GateCoinEndpoint.class;
    }

    public void configure(ApiService.Builder object) {
        GateResult.Deserializer<CoinItem> deserializer;
        ApiService.Builder builder = object;
        Object object2 = new TypeToken<GateResult<CoinItem>>(object2){}.getType();
        object = deserializer;
        deserializer = new GateResult.Deserializer<CoinItem>(CoinItem.class);
        builder.registerTypeAdapter((Type)object2, object);
    }
}

