/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.ExplorerTransactionEndpoint;
import network.minter.explorer.api.converters.ExplorerHistoryTransactionDeserializer;
import network.minter.explorer.models.ExpResult;
import network.minter.explorer.models.HistoryTransaction;
import network.minter.explorer.repo.TxSearchQuery;

public class ExplorerTransactionRepository
extends DataRepository<ExplorerTransactionEndpoint>
implements DataRepository.Configurator {
    public ExplorerTransactionRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Observable<ExpResult<List<HistoryTransaction>>> getTransactions(MinterAddress minterAddress, int n) {
        Preconditions.checkArgument((minterAddress != null ? 1 : 0) != 0, (Object)"Address can't be null");
        ExplorerTransactionEndpoint explorerTransactionEndpoint = (ExplorerTransactionEndpoint)object.getInstantService();
        Object object = minterAddress.toString();
        return explorerTransactionEndpoint.getTransactionsByAddress((String)object, n);
    }

    public Observable<ExpResult<List<HistoryTransaction>>> getTransactions(TxSearchQuery txSearchQuery) {
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(txSearchQuery.build());
    }

    public Observable<ExpResult<List<HistoryTransaction>>> getTransactions(MinterAddress minterAddress) {
        Preconditions.checkArgument((minterAddress != null ? 1 : 0) != 0, (Object)"Address can't be null");
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactionsByAddress(minterAddress.toString());
    }

    public Observable<ExpResult<List<HistoryTransaction>>> getTransactions(MinterAddress object, int n, TxFilter txFilter) {
        Object object2;
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"Address can't be null");
        if (txFilter != null && txFilter != TxFilter.None) {
            ExplorerTransactionEndpoint explorerTransactionEndpoint = (ExplorerTransactionEndpoint)object2.getInstantService();
            object2 = object.toString();
            object = n;
            String string = txFilter.value;
            return explorerTransactionEndpoint.getTransactionsByAddress((String)object2, (Integer)object, string);
        }
        ExplorerTransactionEndpoint explorerTransactionEndpoint = (ExplorerTransactionEndpoint)object2.getInstantService();
        object2 = object.toString();
        return explorerTransactionEndpoint.getTransactionsByAddress((String)object2, n);
    }

    public Observable<ExpResult<List<HistoryTransaction>>> getTransactions(MinterAddress object, long l, long l2, TxFilter txFilter) {
        if (txFilter != null && txFilter != TxFilter.None) {
            Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"Address can't be null");
            Preconditions.checkArgument((l >= 0L && l2 >= 0L ? 1 : 0) != 0, (Object)"Start and End block must be greater or equals to zero");
            ExplorerTransactionEndpoint explorerTransactionEndpoint = (ExplorerTransactionEndpoint)object2.getInstantService();
            Object object2 = object.toString();
            object = l;
            Long l3 = l2;
            String string = txFilter.value;
            return explorerTransactionEndpoint.getTransactionsByAddress((String)object2, (Long)object, l3, string);
        }
        return object2.getTransactions((MinterAddress)object, l, l2);
    }

    public Observable<ExpResult<List<HistoryTransaction>>> getTransactions(MinterAddress object, long l, long l2) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"Address can't be null");
        Preconditions.checkArgument((l >= 0L && l2 >= 0L ? 1 : 0) != 0, (Object)"Start and End block must be greater or equals to zero");
        ExplorerTransactionEndpoint explorerTransactionEndpoint = (ExplorerTransactionEndpoint)object2.getInstantService();
        Object object2 = object.toString();
        object = l;
        Long l3 = l2;
        return explorerTransactionEndpoint.getTransactionsByAddress((String)object2, (Long)object, l3);
    }

    public Observable<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> object, int n) {
        ArrayList<String> arrayList;
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"Address list can't be null");
        Preconditions.checkArgument((object.size() > 0 ? 1 : 0) != 0, (Object)"Address list can't be empty");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(((MinterAddress)object.next()).toString());
        }
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(arrayList2, n);
    }

    public Observable<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> list) {
        return this.getTransactions(list, 1);
    }

    public Observable<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> object, int n, TxFilter txFilter) {
        ArrayList<String> arrayList;
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"Address list can't be null");
        Preconditions.checkArgument((object.size() > 0 ? 1 : 0) != 0, (Object)"Address list can't be empty");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(((MinterAddress)object.next()).toString());
        }
        if (txFilter != null && txFilter != TxFilter.None) {
            ExplorerTransactionEndpoint explorerTransactionEndpoint = (ExplorerTransactionEndpoint)object2.getInstantService();
            Object object2 = n;
            return explorerTransactionEndpoint.getTransactions(arrayList2, (Integer)object2, txFilter.value);
        }
        return ((ExplorerTransactionEndpoint)object2.getInstantService()).getTransactions(arrayList2, n);
    }

    public Observable<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> object, int n, int n2) {
        ArrayList<String> arrayList;
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"Address list can't be null");
        Preconditions.checkArgument((object.size() > 0 ? 1 : 0) != 0, (Object)"Address list can't be empty");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(((MinterAddress)object.next()).toString());
        }
        ExplorerTransactionEndpoint explorerTransactionEndpoint = (ExplorerTransactionEndpoint)object2.getInstantService();
        Object object2 = n;
        return explorerTransactionEndpoint.getTransactions(arrayList2, (Integer)object2, n2);
    }

    public Observable<ExpResult<HistoryTransaction>> getTransaction(@Nonnull String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"Tx hash can't be null");
        return ((ExplorerTransactionEndpoint)this.getInstantService()).findTransactionByHash(string);
    }

    public void configure(ApiService.Builder builder) {
        ExplorerHistoryTransactionDeserializer explorerHistoryTransactionDeserializer;
        Object object = explorerHistoryTransactionDeserializer;
        explorerHistoryTransactionDeserializer = new ExplorerHistoryTransactionDeserializer();
        builder.registerTypeAdapter(HistoryTransaction.class, object);
    }

    @Nonnull
    protected Class<ExplorerTransactionEndpoint> getServiceClass() {
        return ExplorerTransactionEndpoint.class;
    }

    public static final class TxFilter
    extends Enum<TxFilter> {
        public static final /* enum */ TxFilter None;
        public static final /* enum */ TxFilter Incoming;
        public static final /* enum */ TxFilter Outgoing;
        private static final /* synthetic */ TxFilter[] $VALUES;
        String value;

        public static TxFilter[] values() {
            return (TxFilter[])$VALUES.clone();
        }

        public static TxFilter valueOf(String string) {
            return Enum.valueOf(TxFilter.class, string);
        }

        private TxFilter(String string2) {
            this.value = string2;
        }

        public static TxFilter find(String string) {
            if (string == null) {
                return None;
            }
            for (TxFilter txFilter : TxFilter.values()) {
                if (!string.equals(txFilter.value)) continue;
                return txFilter;
            }
            return null;
        }

        static {
            TxFilter txFilter;
            TxFilter txFilter2;
            TxFilter txFilter3;
            TxFilter txFilter4 = txFilter3;
            None = new TxFilter(null);
            TxFilter txFilter5 = txFilter2;
            Incoming = new TxFilter("incoming");
            TxFilter txFilter6 = txFilter;
            Outgoing = new TxFilter("outcoming");
            $VALUES = new TxFilter[]{txFilter4, txFilter5, txFilter6};
        }
    }
}

