/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.ExplorerAddressEndpoint;
import network.minter.explorer.api.converters.ExplorerAddressBalanceDeserializer;
import network.minter.explorer.api.converters.ExplorerAddressListBalancesDeserializer;
import network.minter.explorer.api.converters.ExplorerCoinDelegationJsonConverter;
import network.minter.explorer.api.converters.ExplorerDelegationListJsonConverter;
import network.minter.explorer.models.AddressBalance;
import network.minter.explorer.models.AddressListBalances;
import network.minter.explorer.models.CoinDelegation;
import network.minter.explorer.models.DelegationList;
import network.minter.explorer.models.ExpResult;
import network.minter.explorer.models.RewardStatistics;

public class ExplorerAddressRepository
extends DataRepository<ExplorerAddressEndpoint>
implements DataRepository.Configurator {
    public ExplorerAddressRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Observable<ExpResult<AddressListBalances>> getAddressesData(List<MinterAddress> object) {
        ArrayList<String> arrayList;
        List<MinterAddress> list = object;
        Preconditions.checkNotNull(list, (String)"List can't be null");
        Preconditions.checkArgument((list.size() > 0 ? 1 : 0) != 0, (Object)"List can't be empty");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            MinterAddress minterAddress = (MinterAddress)object.next();
            if (minterAddress == null) continue;
            arrayList2.add(minterAddress.toString());
        }
        Preconditions.checkArgument((arrayList2.size() > 0 ? 1 : 0) != 0, (Object)"List contains all null items");
        ExplorerAddressRepository explorerAddressRepository = this;
        return ((ExplorerAddressEndpoint)explorerAddressRepository.getInstantService(explorerAddressRepository)).balanceMultiple(arrayList2);
    }

    public Observable<ExpResult<AddressBalance>> getAddressData(MinterAddress minterAddress) {
        return this.getAddressData(minterAddress.toString());
    }

    public Observable<ExpResult<AddressBalance>> getAddressData(MinterAddress minterAddress, boolean bl) {
        return this.getAddressData(minterAddress.toString(), bl);
    }

    public Observable<ExpResult<AddressBalance>> getAddressData(String string) {
        Preconditions.checkArgument((boolean)MinterAddress.testString((CharSequence)string), (Object)"Invalid address");
        return ((ExplorerAddressEndpoint)this.getInstantService()).balance(string);
    }

    public Observable<ExpResult<AddressBalance>> getAddressData(String string, boolean bl) {
        return ((ExplorerAddressEndpoint)this.getInstantService()).balance(string, bl ? 1 : 0);
    }

    public Observable<ExpResult<DelegationList>> getDelegations(MinterAddress minterAddress) {
        Preconditions.checkNotNull((Object)minterAddress, (String)"Address can't be null");
        return ((ExplorerAddressEndpoint)this.getInstantService()).getDelegationsForAddress(minterAddress.toString(), 1);
    }

    public Observable<ExpResult<DelegationList>> getDelegations(MinterAddress minterAddress, Integer n) {
        Preconditions.checkNotNull((Object)minterAddress, (String)"Address can't be null");
        return ((ExplorerAddressEndpoint)this.getInstantService()).getDelegationsForAddress(minterAddress.toString(), n);
    }

    public Observable<ExpResult<List<RewardStatistics>>> getRewardStatistics(String string) {
        Preconditions.checkNotNull((Object)string, (String)"Address can't be null");
        return ((ExplorerAddressEndpoint)this.getInstantService()).getRewardStatistics(string);
    }

    public Observable<ExpResult<List<RewardStatistics>>> getRewardStatistics(MinterAddress minterAddress) {
        Preconditions.checkNotNull((Object)minterAddress, (String)"Address can't be null");
        return ((ExplorerAddressEndpoint)this.getInstantService()).getRewardStatistics(minterAddress.toString());
    }

    public Observable<ExpResult<List<RewardStatistics>>> getRewardStatistics(String string, String string2, String string3) {
        Preconditions.checkNotNull((Object)string, (String)"Address can't be null");
        return ((ExplorerAddressEndpoint)this.getInstantService()).getRewardStatistics(string, string2, string3);
    }

    public Observable<ExpResult<List<RewardStatistics>>> getRewardStatistics(MinterAddress minterAddress, String string, String string2) {
        Preconditions.checkNotNull((Object)minterAddress, (String)"Address can't be null");
        return ((ExplorerAddressEndpoint)this.getInstantService()).getRewardStatistics(minterAddress.toString(), string, string2);
    }

    @Nonnull
    protected Class<ExplorerAddressEndpoint> getServiceClass() {
        return ExplorerAddressEndpoint.class;
    }

    public void configure(ApiService.Builder builder) {
        ExplorerDelegationListJsonConverter explorerDelegationListJsonConverter;
        ExplorerCoinDelegationJsonConverter explorerCoinDelegationJsonConverter;
        ExplorerAddressListBalancesDeserializer explorerAddressListBalancesDeserializer;
        ExplorerAddressBalanceDeserializer explorerAddressBalanceDeserializer;
        ApiService.Builder builder2 = builder;
        Object object = explorerAddressBalanceDeserializer;
        explorerAddressBalanceDeserializer = new ExplorerAddressBalanceDeserializer();
        builder2.registerTypeAdapter(AddressBalance.class, object);
        object = explorerAddressListBalancesDeserializer;
        explorerAddressListBalancesDeserializer = new ExplorerAddressListBalancesDeserializer();
        builder2.registerTypeAdapter(AddressListBalances.class, object);
        object = explorerCoinDelegationJsonConverter;
        explorerCoinDelegationJsonConverter = new ExplorerCoinDelegationJsonConverter();
        builder2.registerTypeAdapter(CoinDelegation.class, object);
        object = explorerDelegationListJsonConverter;
        explorerDelegationListJsonConverter = new ExplorerDelegationListJsonConverter();
        builder2.registerTypeAdapter(DelegationList.class, object);
    }
}

