/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.models;

import com.annimon.stream.Objects;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.operational.CheckTransaction;
import network.minter.blockchain.utils.Base64UrlSafe;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterHash;
import network.minter.core.crypto.MinterPublicKey;
import network.minter.core.internal.log.Mint;
import network.minter.explorer.models.CoinItemBase;
import org.parceler.Parcel;
import org.parceler.Transient;

@Parcel
public class HistoryTransaction
implements Serializable,
Comparable<HistoryTransaction> {
    public BigInteger txn;
    public MinterHash hash;
    public BigInteger nonce;
    @SerializedName(value="height")
    public BigInteger block;
    public Date timestamp;
    public BigDecimal fee;
    @SerializedName(value="gas_coin")
    public CoinItemBase gasCoin;
    public Type type;
    public MinterAddress from;
    @Transient
    public Object data;
    public String payload;

    public Type getType() {
        return this.type;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public BigInteger getBlock() {
        return this.block;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public BigInteger getTxNumber() {
        return this.txn;
    }

    public String getPayload() {
        return this.payload;
    }

    public MinterHash getHash() {
        return this.hash;
    }

    public MinterAddress getFrom() {
        return this.from;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public boolean isIncoming(List<MinterAddress> list) {
        Object object = ((HistoryTransaction)((Object)iterator)).type;
        if (object == Type.Send) {
            return list.contains(((TxSendCoinResult)((HistoryTransaction)((Object)iterator)).getData()).to);
        }
        if (object == Type.MultiSend) {
            Iterator<TxSendCoinResult> iterator = (TxMultisendResult)((HistoryTransaction)((Object)iterator)).getData();
            object = ((TxMultisendResult)((Object)iterator)).items;
            if (object != null && !object.isEmpty()) {
                iterator = ((TxMultisendResult)((Object)iterator)).items.iterator();
                while (iterator.hasNext()) {
                    if (!list.contains(iterator.next().to)) continue;
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    public <T> T getData() {
        return (T)this.data;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (HistoryTransaction)object;
            return this.block.equals(((HistoryTransaction)object).block) && Objects.equals((Object)this.fee, (Object)((HistoryTransaction)object).fee) && Objects.equals((Object)this.hash, (Object)((HistoryTransaction)object).hash) && Objects.equals((Object)this.nonce, (Object)((HistoryTransaction)object).nonce) && Objects.equals((Object)this.timestamp, (Object)((HistoryTransaction)object).timestamp) && Objects.equals((Object)((Object)this.type), (Object)((Object)((HistoryTransaction)object).type)) && Objects.equals((Object)this.data, (Object)((HistoryTransaction)object).data);
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[7];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.hash;
        objectArray2[1] = this.nonce;
        objectArray2[2] = this.block;
        objectArray2[3] = this.timestamp;
        objectArray2[4] = this.fee;
        objectArray2[5] = this.type;
        objectArray[6] = this.data;
        return Objects.hash((Object[])objectArray);
    }

    @Override
    public int compareTo(@Nonnull HistoryTransaction historyTransaction) {
        return historyTransaction.timestamp.compareTo(this.timestamp);
    }

    public static final class Type
    extends Enum<Type> {
        @SerializedName(value="1")
        public static final /* enum */ Type Send;
        @SerializedName(value="2")
        public static final /* enum */ Type SellCoin;
        @SerializedName(value="3")
        public static final /* enum */ Type SellAllCoins;
        @SerializedName(value="4")
        public static final /* enum */ Type BuyCoin;
        @SerializedName(value="5")
        public static final /* enum */ Type CreateCoin;
        @SerializedName(value="6")
        public static final /* enum */ Type DeclareCandidacy;
        @SerializedName(value="7")
        public static final /* enum */ Type Delegate;
        @SerializedName(value="8")
        public static final /* enum */ Type Unbond;
        @SerializedName(value="9")
        public static final /* enum */ Type RedeemCheck;
        @SerializedName(value="10")
        public static final /* enum */ Type SetCandidateOnline;
        @SerializedName(value="11")
        public static final /* enum */ Type SetCandidateOffline;
        @SerializedName(value="12")
        public static final /* enum */ Type CreateMultisigAddress;
        @SerializedName(value="13")
        public static final /* enum */ Type MultiSend;
        @SerializedName(value="14")
        public static final /* enum */ Type EditCandidate;
        @SerializedName(value="15")
        public static final /* enum */ Type SetHaltBlock;
        @SerializedName(value="16")
        public static final /* enum */ Type RecreateCoin;
        @SerializedName(value="17")
        public static final /* enum */ Type EditCoinOwner;
        @SerializedName(value="18")
        public static final /* enum */ Type EditMultisig;
        @SerializedName(value="19")
        public static final /* enum */ Type PriceVote;
        @SerializedName(value="20")
        public static final /* enum */ Type EditCandidatePublicKey;
        private static final /* synthetic */ Type[] $VALUES;
        Class<?> mCls;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        private Type(Class<?> clazz) {
            this.mCls = clazz;
        }

        static {
            Type type;
            Type type2;
            Type type3;
            Type type4;
            Type type5;
            Type type6;
            Type type7;
            Type type8;
            Type type9;
            Type type10;
            Type type11;
            Type type12;
            Type type13;
            Type type14;
            Type type15;
            Type type16;
            Type type17;
            Type type18;
            Type type19;
            Type type20;
            Type type21 = type20;
            Send = new Type(TxSendCoinResult.class);
            Type type22 = type19;
            SellCoin = new Type(TxConvertCoinResult.class);
            Type type23 = type18;
            SellAllCoins = new Type(TxConvertCoinResult.class);
            Type type24 = type17;
            BuyCoin = new Type(TxConvertCoinResult.class);
            Type type25 = type16;
            CreateCoin = new Type(TxCreateCoinResult.class);
            Type type26 = type15;
            DeclareCandidacy = new Type(TxDeclareCandidacyResult.class);
            Type type27 = type14;
            Delegate = new Type(TxDelegateUnbondResult.class);
            Type type28 = type13;
            Unbond = new Type(TxDelegateUnbondResult.class);
            Type type29 = type12;
            RedeemCheck = new Type(TxRedeemCheckResult.class);
            Type type30 = type11;
            SetCandidateOnline = new Type(TxSetCandidateOnlineOfflineResult.class);
            Type type31 = type10;
            SetCandidateOffline = new Type(TxSetCandidateOnlineOfflineResult.class);
            Type type32 = type9;
            CreateMultisigAddress = new Type(TxCreateMultisigResult.class);
            Type type33 = type8;
            MultiSend = new Type(TxMultisendResult.class);
            Type type34 = type7;
            EditCandidate = new Type(TxEditCandidateResult.class);
            Type type35 = type6;
            SetHaltBlock = new Type(TxSetHaltBlockResult.class);
            Type type36 = type5;
            RecreateCoin = new Type(TxRecreateCoinResult.class);
            Type type37 = type4;
            EditCoinOwner = new Type(TxChangeCoinOwnerResult.class);
            Type type38 = type3;
            EditMultisig = new Type(TxEditMultisigResult.class);
            Type type39 = type2;
            PriceVote = new Type(TxPriceVoteResult.class);
            Type type40 = type;
            EditCandidatePublicKey = new Type(TxEditCandidatePublicKeyResult.class);
            $VALUES = new Type[]{type21, type22, type23, type24, type25, type26, type27, type28, type29, type30, type31, type32, type33, type34, type35, type36, type37, type38, type39, type40};
        }

        public Class<?> getCls() {
            return this.mCls;
        }
    }

    @Parcel
    public static class TxSendCoinResult {
        public MinterAddress to;
        public CoinItemBase coin;
        @SerializedName(value="value")
        public BigDecimal amount;

        public MinterAddress getTo() {
            return this.to;
        }

        public String getCoin() {
            CoinItemBase coinItemBase = ((TxSendCoinResult)((Object)coinItemBase)).coin;
            if (coinItemBase == null) {
                return null;
            }
            return coinItemBase.symbol;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }
    }

    @Parcel
    public static class TxMultisendResult {
        @SerializedName(value="list")
        public List<TxSendCoinResult> items;

        @Nonnull
        public List<TxSendCoinResult> findByRecipient(@Nonnull MinterAddress minterAddress) {
            List<TxSendCoinResult> list = ((TxMultisendResult)((Object)arrayList2)).items;
            if (list != null && !list.isEmpty()) {
                ArrayList arrayList;
                TxMultisendResult txMultisendResult = arrayList2;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList(1);
                for (TxSendCoinResult txSendCoinResult : txMultisendResult.items) {
                    if (!txSendCoinResult.to.equals((Object)minterAddress)) continue;
                    arrayList2.add(txSendCoinResult);
                }
                return arrayList2;
            }
            return Collections.emptyList();
        }
    }

    @Parcel
    public static class TxEditCandidateResult {
        @SerializedName(value="reward_address")
        public MinterAddress rewardAddress;
        @SerializedName(value="owner_address")
        public MinterAddress ownerAddress;
        @SerializedName(value="control_address")
        public MinterAddress controlAddress;
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        public MinterAddress getRewardAddress() {
            return this.rewardAddress;
        }

        public MinterAddress getOwnerAddress() {
            return this.ownerAddress;
        }

        public MinterAddress getControlAddress() {
            return this.controlAddress;
        }
    }

    @Parcel
    public static class TxCreateMultisigResult {
        public BigInteger threshold;
        public List<BigInteger> weights;
        public List<MinterAddress> addresses;
        @SerializedName(value="multisig_address")
        public MinterAddress multisigAddress;

        public TxCreateMultisigResult() {
            ArrayList arrayList;
            ArrayList arrayList2;
            Object object = arrayList2;
            arrayList2 = new ArrayList();
            v1.weights = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.addresses = object;
        }
    }

    @Parcel
    public static class CheckData {
        public CoinItemBase coin;
        @SerializedName(value="gas_coin")
        public CoinItemBase gasCoin;
        public String nonce;
        public BigDecimal value;
        public MinterAddress sender;
        @SerializedName(value="due_block")
        public BigInteger dueBlock;

        public String getCoin() {
            return this.coin.toString();
        }

        public String getNonce() {
            return this.nonce;
        }

        public MinterAddress getSender() {
            return this.sender;
        }

        public BigInteger getDueBlock() {
            return this.dueBlock;
        }

        public BigDecimal getValue() {
            return this.value;
        }
    }

    @Parcel
    public static class TxRedeemCheckResult {
        @SerializedName(value="raw_check")
        public String rawCheck;
        public String proof;
        public CheckData check;

        public String getRawProof() {
            return this.proof;
        }

        public CheckData getCheck() {
            return this.check;
        }

        public String getRawCheck() {
            return this.rawCheck;
        }

        public CheckTransaction getCheckTransaction() {
            TxRedeemCheckResult txRedeemCheckResult;
            if (txRedeemCheckResult.rawCheck.isEmpty()) {
                return null;
            }
            try {
                txRedeemCheckResult = CheckTransaction.fromEncoded((String)Base64UrlSafe.decode((String)txRedeemCheckResult.rawCheck).toHexString());
            }
            catch (Throwable throwable) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = txRedeemCheckResult.rawCheck;
                Mint.d((String)"Unable to decode raw check: %s", (Object[])objectArray2);
                txRedeemCheckResult = null;
            }
            return txRedeemCheckResult;
        }
    }

    @Parcel
    public static class TxDelegateUnbondResult {
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public CoinItemBase coin;
        public BigDecimal value = BigDecimal.ZERO;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public String getCoin() {
            CoinItemBase coinItemBase = ((TxDelegateUnbondResult)((Object)coinItemBase)).coin;
            if (coinItemBase == null) {
                return null;
            }
            return coinItemBase.symbol;
        }
    }

    @Parcel
    public static class TxSetCandidateOnlineOfflineResult {
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }
    }

    @Parcel
    public static class TxDeclareCandidacyResult {
        public MinterAddress address;
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public int commission;
        public CoinItemBase coin;
        public BigDecimal stake;

        public MinterAddress getAddress() {
            return this.address;
        }

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        public int getCommission() {
            return this.commission;
        }

        public String getCoin() {
            CoinItemBase coinItemBase = ((TxDeclareCandidacyResult)((Object)coinItemBase)).coin;
            if (coinItemBase == null) {
                return null;
            }
            return coinItemBase.symbol;
        }

        public BigDecimal getStake() {
            if (this.stake == null) {
                this.stake = BigDecimal.ZERO;
            }
            return this.stake;
        }
    }

    @Parcel
    public static class TxConvertCoinResult {
        @SerializedName(value="coin_to_sell")
        public CoinItemBase coinToSell;
        @SerializedName(value="coin_to_buy")
        public CoinItemBase coinToBuy;
        @SerializedName(value="value_to_buy")
        public BigDecimal valueToBuy;
        @SerializedName(value="value_to_sell")
        public BigDecimal valueToSell;
        @SerializedName(value="maximum_value_to_sell")
        public BigDecimal maxValueToSell;
        @SerializedName(value="minimum_value_to_buy")
        public BigDecimal minValueToBuy;

        public BigDecimal getMinValueToBuy() {
            return this.minValueToBuy;
        }

        public BigDecimal getMaxValueToSell() {
            return this.maxValueToSell;
        }

        public String getCoinToSell() {
            CoinItemBase coinItemBase = ((TxConvertCoinResult)((Object)coinItemBase)).coinToSell;
            if (coinItemBase == null) {
                return null;
            }
            return coinItemBase.symbol;
        }

        public String getCoinToBuy() {
            CoinItemBase coinItemBase = ((TxConvertCoinResult)((Object)coinItemBase)).coinToBuy;
            if (coinItemBase == null) {
                return null;
            }
            return coinItemBase.symbol;
        }

        public BigDecimal getValueToBuy() {
            if (this.valueToBuy == null) {
                this.valueToBuy = BigDecimal.ZERO;
            }
            return this.valueToBuy;
        }

        public BigDecimal getValueToSell() {
            if (this.valueToSell == null) {
                this.valueToSell = BigDecimal.ZERO;
            }
            return this.valueToSell;
        }
    }

    @Parcel
    public static class TxChangeCoinOwnerResult {
        public String symbol;
        @SerializedName(value="new_owner")
        public MinterAddress newOwner;
    }

    @Parcel
    public static class TxRecreateCoinResult
    extends TxCreateCoinResult {
    }

    @Parcel
    public static class TxCreateCoinResult {
        public String name;
        public String symbol;
        @SerializedName(value="initial_amount")
        public BigDecimal initialAmount;
        @SerializedName(value="initial_reserve")
        public BigDecimal initialReserve;
        @SerializedName(value="constant_reserve_ratio")
        public int constantReserveRatio;
        @SerializedName(value="max_supply")
        public BigDecimal maxSupply = BigDecimal.ZERO;

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            String string = ((TxCreateCoinResult)((Object)string)).symbol;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getInitialAmount() {
            return this.initialAmount;
        }

        public BigDecimal getInitialReserve() {
            return this.initialReserve;
        }

        public int getConstantReserveRatio() {
            return this.constantReserveRatio;
        }
    }

    @Parcel
    public static class TxPriceVoteResult {
        public BigInteger price;
    }

    @Parcel
    public static class TxEditMultisigResult
    extends TxCreateMultisigResult {
    }

    @Parcel
    public static class TxSetHaltBlockResult {
        public BigInteger height;
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
    }

    public static class TxEditCandidatePublicKeyResult {
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        @SerializedName(value="new_pub_key")
        public MinterPublicKey newPublicKey;
    }

    public static class TxDefaultResult {
    }

    public static final class Status
    extends Enum<Status> {
        @SerializedName(value="success")
        public static final /* enum */ Status Success;
        @SerializedName(value="error")
        public static final /* enum */ Status Error;
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String string) {
            return Enum.valueOf(Status.class, string);
        }

        static {
            Status status;
            Status status2;
            Status status3 = status2;
            Success = new Status();
            Status status4 = status;
            Error = new Status();
            $VALUES = new Status[]{status3, status4};
        }
    }
}

