/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import javax.annotation.Nonnull;
import network.minter.blockchain.models.HistoryTransaction;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.blockchain.repo.BlockChainTransactionRepository;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.core.internal.helpers.CollectionsHelper;
import network.minter.explorer.api.GateTransactionEndpoint;
import network.minter.explorer.models.GateResult;
import network.minter.explorer.models.PushResult;
import retrofit2.Call;

public class GateTransactionRepository
extends DataRepository<GateTransactionEndpoint>
implements DataRepository.Configurator {
    public GateTransactionRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Call<GateResult<PushResult>> sendTransaction(@Nonnull TransactionSign transactionSign) {
        Preconditions.checkArgument((transactionSign != null && transactionSign.getTxSign() != null ? 1 : 0) != 0, (Object)"Transaction signature required!");
        return ((GateTransactionEndpoint)this.getInstantService()).sendTransaction(CollectionsHelper.asMap((Object[])new String[]{"transaction", transactionSign.getTxSign()}));
    }

    @Nonnull
    protected Class<GateTransactionEndpoint> getServiceClass() {
        return GateTransactionEndpoint.class;
    }

    public void configure(ApiService.Builder builder) {
        BlockChainTransactionRepository.HistoryTransactionDeserializer historyTransactionDeserializer;
        GateTransactionRepository gateTransactionRepository = historyTransactionDeserializer;
        historyTransactionDeserializer = new BlockChainTransactionRepository.HistoryTransactionDeserializer();
        builder.registerTypeAdapter(HistoryTransaction.class, (Object)gateTransactionRepository);
    }
}

