/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.models;

import com.annimon.stream.Objects;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterHash;
import network.minter.core.crypto.MinterPublicKey;
import org.parceler.Parcel;
import org.parceler.Transient;

@Parcel
public class HistoryTransaction
implements Serializable,
Comparable<HistoryTransaction> {
    public BigInteger txn;
    public MinterHash hash;
    public BigInteger nonce;
    @SerializedName(value="height")
    public BigInteger block;
    public Date timestamp;
    public BigDecimal fee;
    @SerializedName(value="gas_coin")
    public String gasCoin;
    public Type type;
    public MinterAddress from;
    @Transient
    public Object data;
    public String payload;

    public Type getType() {
        return this.type;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public BigInteger getBlock() {
        return this.block;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public BigInteger getTxNumber() {
        return this.txn;
    }

    public String getPayload() {
        return this.payload;
    }

    public MinterHash getHash() {
        return this.hash;
    }

    public MinterAddress getFrom() {
        return this.from;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public boolean isIncoming(List<MinterAddress> list) {
        Object object = ((HistoryTransaction)((Object)iterator)).type;
        if (object == Type.Send) {
            return list.contains(((TxSendCoinResult)((HistoryTransaction)((Object)iterator)).getData()).to);
        }
        if (object == Type.MultiSend) {
            Iterator<TxSendCoinResult> iterator = (TxMultisendResult)((HistoryTransaction)((Object)iterator)).getData();
            object = ((TxMultisendResult)((Object)iterator)).items;
            if (object != null && !object.isEmpty()) {
                iterator = ((TxMultisendResult)((Object)iterator)).items.iterator();
                while (iterator.hasNext()) {
                    if (!list.contains(iterator.next().to)) continue;
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    public <T> T getData() {
        return (T)this.data;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && HistoryTransaction.class == object.getClass()) {
            object = (HistoryTransaction)object;
            return this.block.equals(((HistoryTransaction)object).block) && Objects.equals((Object)this.fee, (Object)((HistoryTransaction)object).fee) && Objects.equals((Object)this.hash, (Object)((HistoryTransaction)object).hash) && Objects.equals((Object)this.nonce, (Object)((HistoryTransaction)object).nonce) && Objects.equals((Object)this.timestamp, (Object)((HistoryTransaction)object).timestamp) && Objects.equals((Object)((Object)this.type), (Object)((Object)((HistoryTransaction)object).type)) && Objects.equals((Object)this.data, (Object)((HistoryTransaction)object).data);
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[7];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.hash;
        objectArray2[1] = this.nonce;
        objectArray2[2] = this.block;
        objectArray2[3] = this.timestamp;
        objectArray2[4] = this.fee;
        objectArray2[5] = this.type;
        objectArray[6] = this.data;
        return Objects.hash((Object[])objectArray);
    }

    @Override
    public int compareTo(@Nonnull HistoryTransaction historyTransaction) {
        return historyTransaction.timestamp.compareTo(this.timestamp);
    }

    @Parcel
    public static class TxEditCandidateResult {
        @SerializedName(value="reward_address")
        public MinterAddress rewardAddress;
        @SerializedName(value="owner_address")
        public MinterAddress ownerAddress;
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        public MinterAddress getRewardAddress() {
            return this.rewardAddress;
        }

        public MinterAddress getOwnerAddress() {
            return this.ownerAddress;
        }
    }

    @Parcel
    public static class TxMultisendResult {
        @SerializedName(value="list")
        public List<TxSendCoinResult> items;

        @Nonnull
        public List<TxSendCoinResult> findByRecipient(@Nonnull MinterAddress minterAddress) {
            List<TxSendCoinResult> list = ((TxMultisendResult)((Object)arrayList2)).items;
            if (list != null && !list.isEmpty()) {
                ArrayList arrayList;
                TxMultisendResult txMultisendResult = arrayList2;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList(1);
                for (TxSendCoinResult txSendCoinResult : txMultisendResult.items) {
                    if (!txSendCoinResult.to.equals((Object)minterAddress)) continue;
                    arrayList2.add(txSendCoinResult);
                }
                return arrayList2;
            }
            return Collections.emptyList();
        }
    }

    @Parcel
    public static class TxCreateMultisigResult {
        public BigInteger threshold;
        public List<BigInteger> weights;
        public List<MinterAddress> addresses;
        @SerializedName(value="multisig_address")
        public MinterAddress multisigAddress;

        public TxCreateMultisigResult() {
            ArrayList arrayList;
            ArrayList arrayList2;
            Object object = arrayList2;
            arrayList2 = new ArrayList();
            v1.weights = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.addresses = object;
        }
    }

    @Parcel
    public static class CheckData {
        public String coin;
        public String nonce;
        public BigDecimal value;
        public MinterAddress sender;
        @SerializedName(value="due_block")
        public BigInteger dueBlock;

        public String getCoin() {
            return this.coin;
        }

        public String getNonce() {
            return this.nonce;
        }

        public MinterAddress getSender() {
            return this.sender;
        }

        public BigInteger getDueBlock() {
            return this.dueBlock;
        }

        public BigDecimal getValue() {
            return this.value;
        }
    }

    @Parcel
    public static class TxRedeemCheckResult {
        @SerializedName(value="raw_check")
        public String rawCheck;
        public String proof;
        @Deprecated
        public CheckData check;

        public String getRawProof() {
            return this.proof;
        }

        @Deprecated
        public CheckData getCheck() {
            return this.check;
        }

        public String getRawCheck() {
            return this.rawCheck;
        }
    }

    @Parcel
    public static class TxDelegateUnbondResult {
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public String coin;
        public BigDecimal value = BigDecimal.ZERO;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        @Deprecated
        public BigDecimal getStake() {
            return this.getValue();
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public String getCoin() {
            String string = ((TxDelegateUnbondResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }
    }

    @Parcel
    public static class TxSetCandidateOnlineOfflineResult {
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }
    }

    @Parcel
    public static class TxDeclareCandidacyResult {
        public MinterAddress address;
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public int commission;
        public String coin;
        public BigDecimal stake;

        public MinterAddress getAddress() {
            return this.address;
        }

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        public int getCommission() {
            return this.commission;
        }

        public String getCoin() {
            String string = ((TxDeclareCandidacyResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getStake() {
            if (this.stake == null) {
                this.stake = BigDecimal.ZERO;
            }
            return this.stake;
        }
    }

    @Parcel
    public static class TxConvertCoinResult {
        @SerializedName(value="coin_to_sell")
        public String coinToSell;
        @SerializedName(value="coin_to_buy")
        public String coinToBuy;
        @SerializedName(value="value_to_buy")
        public BigDecimal valueToBuy;
        @SerializedName(value="value_to_sell")
        public BigDecimal valueToSell;
        @SerializedName(value="maximum_value_to_sell")
        public BigDecimal maxValueToSell;
        @SerializedName(value="minimum_value_to_buy")
        public BigDecimal minValueToBuy;

        public BigDecimal getMinValueToBuy() {
            return this.minValueToBuy;
        }

        public BigDecimal getMaxValueToSell() {
            return this.maxValueToSell;
        }

        public String getCoinToSell() {
            String string = ((TxConvertCoinResult)((Object)string)).coinToSell;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public String getCoinToBuy() {
            String string = ((TxConvertCoinResult)((Object)string)).coinToBuy;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getValueToBuy() {
            if (this.valueToBuy == null) {
                this.valueToBuy = BigDecimal.ZERO;
            }
            return this.valueToBuy;
        }

        public BigDecimal getValueToSell() {
            if (this.valueToSell == null) {
                this.valueToSell = BigDecimal.ZERO;
            }
            return this.valueToSell;
        }
    }

    @Parcel
    public static class TxCreateResult {
        public String name;
        public String symbol;
        @SerializedName(value="initial_amount")
        public BigDecimal initialAmount;
        @SerializedName(value="initial_reserve")
        public BigDecimal initialReserve;
        @SerializedName(value="constant_reserve_ratio")
        public int constantReserveRatio;
        @SerializedName(value="max_supply")
        public BigDecimal maxSupply = BigDecimal.ZERO;

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            String string = ((TxCreateResult)((Object)string)).symbol;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getInitialAmount() {
            return this.initialAmount;
        }

        public BigDecimal getInitialReserve() {
            return this.initialReserve;
        }

        public int getConstantReserveRatio() {
            return this.constantReserveRatio;
        }
    }

    @Parcel
    public static class TxSendCoinResult {
        public MinterAddress to;
        public String coin;
        @SerializedName(value="value")
        public BigDecimal amount;

        public MinterAddress getTo() {
            return this.to;
        }

        public String getCoin() {
            String string = ((TxSendCoinResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getAmount() {
            return this.amount;
        }
    }

    public static class TxDefaultResult {
    }

    public static final class Type
    extends Enum<Type> {
        @SerializedName(value="1")
        public static final /* enum */ Type Send;
        @SerializedName(value="2")
        public static final /* enum */ Type SellCoin;
        @SerializedName(value="3")
        public static final /* enum */ Type SellAllCoins;
        @SerializedName(value="4")
        public static final /* enum */ Type BuyCoin;
        @SerializedName(value="5")
        public static final /* enum */ Type CreateCoin;
        @SerializedName(value="6")
        public static final /* enum */ Type DeclareCandidacy;
        @SerializedName(value="7")
        public static final /* enum */ Type Delegate;
        @SerializedName(value="8")
        public static final /* enum */ Type Unbond;
        @SerializedName(value="9")
        public static final /* enum */ Type RedeemCheck;
        @SerializedName(value="10")
        public static final /* enum */ Type SetCandidateOnline;
        @SerializedName(value="11")
        public static final /* enum */ Type SetCandidateOffline;
        @SerializedName(value="12")
        public static final /* enum */ Type CreateMultisigAddress;
        @SerializedName(value="13")
        public static final /* enum */ Type MultiSend;
        @SerializedName(value="14")
        public static final /* enum */ Type EditCandidate;
        private static final /* synthetic */ Type[] $VALUES;
        Class<?> mCls;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        private Type(Class<?> clazz) {
            this.mCls = clazz;
        }

        static {
            Type type;
            Send = new Type(TxSendCoinResult.class);
            SellCoin = new Type(TxConvertCoinResult.class);
            SellAllCoins = new Type(TxConvertCoinResult.class);
            BuyCoin = new Type(TxConvertCoinResult.class);
            CreateCoin = new Type(TxCreateResult.class);
            DeclareCandidacy = new Type(TxDeclareCandidacyResult.class);
            Delegate = new Type(TxDelegateUnbondResult.class);
            Unbond = new Type(TxDelegateUnbondResult.class);
            RedeemCheck = new Type(TxRedeemCheckResult.class);
            SetCandidateOnline = new Type(TxSetCandidateOnlineOfflineResult.class);
            SetCandidateOffline = new Type(TxSetCandidateOnlineOfflineResult.class);
            CreateMultisigAddress = new Type(TxCreateMultisigResult.class);
            MultiSend = new Type(TxMultisendResult.class);
            Type type2 = type;
            EditCandidate = new Type(TxEditCandidateResult.class);
            $VALUES = new Type[]{Send, SellCoin, SellAllCoins, BuyCoin, CreateCoin, DeclareCandidacy, Delegate, Unbond, RedeemCheck, SetCandidateOnline, SetCandidateOffline, CreateMultisigAddress, MultiSend, type2};
        }

        public Class<?> getCls() {
            return this.mCls;
        }
    }

    public static final class Status
    extends Enum<Status> {
        @SerializedName(value="success")
        public static final /* enum */ Status Success;
        @SerializedName(value="error")
        public static final /* enum */ Status Error;
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String string) {
            return Enum.valueOf(Status.class, string);
        }

        static {
            Status status;
            Success = new Status();
            Status status2 = status;
            Error = new Status();
            $VALUES = new Status[]{Success, status2};
        }
    }
}

