/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.models;

import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import network.minter.core.crypto.MinterAddress;
import org.parceler.Parcel;

@Parcel
public class AddressData {
    public Map<String, CoinBalance> coins;
    public MinterAddress address;
    public BigDecimal availableBalanceInBase;
    public BigDecimal availableBalanceInUSD;
    public BigDecimal totalBalanceInBase;
    public BigDecimal totalBalanceInUSD;

    public AddressData() {
        BigDecimal bigDecimal;
        this.availableBalanceInBase = bigDecimal = BigDecimal.ZERO;
        this.availableBalanceInUSD = bigDecimal;
        this.totalBalanceInBase = bigDecimal;
        this.totalBalanceInUSD = bigDecimal;
        this.coins = new HashMap<String, CoinBalance>();
    }

    public Map<String, CoinBalance> getCoins() {
        if (this.coins == null) {
            this.coins = new HashMap<String, CoinBalance>();
        }
        return this.coins;
    }

    public void fillDefaultsOnEmpty() {
        if (((AddressData)((Object)coinBalance2)).getCoins().isEmpty()) {
            CoinBalance coinBalance;
            CoinBalance coinBalance2 = coinBalance;
            coinBalance = new CoinBalance("MNT", BigDecimal.ZERO);
            ((AddressData)((Object)coinBalance2)).coins.put("MNT", coinBalance2);
        }
    }

    public BigDecimal getTotalBalance() {
        if (((AddressData)object).getCoins().isEmpty()) {
            return BigDecimal.ZERO;
        }
        AddressData addressData = object;
        Object object = BigDecimal.ZERO;
        Iterator<Map.Entry<String, CoinBalance>> iterator = addressData.getCoins().entrySet().iterator();
        while (iterator.hasNext()) {
            object = ((BigDecimal)object).add(iterator.next().getValue().getAmount());
        }
        return object;
    }

    @Parcel
    public static class CoinBalance {
        public String coin;
        public BigDecimal amount;

        public CoinBalance() {
        }

        public CoinBalance(String string, BigDecimal bigDecimal) {
            this.coin = string;
            this.amount = bigDecimal;
        }

        public String getCoin() {
            String string = ((CoinBalance)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getAmount() {
            return (BigDecimal)MoreObjects.firstNonNull((Object)this.amount, (Object)BigDecimal.ZERO);
        }
    }
}

