/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.ExplorerAddressEndpoint;
import network.minter.explorer.api.converters.ExplorerAddressDataDeserializer;
import network.minter.explorer.models.AddressData;
import network.minter.explorer.models.BCExplorerResult;
import network.minter.explorer.models.DelegationInfo;
import network.minter.explorer.models.ExpResult;
import retrofit2.Call;

public class ExplorerAddressRepository
extends DataRepository<ExplorerAddressEndpoint>
implements DataRepository.Configurator {
    public ExplorerAddressRepository(@Nonnull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<BCExplorerResult<List<AddressData>>> getAddressesData(List<MinterAddress> addresses) {
        Preconditions.checkNotNull(addresses, (String)"List can't be null");
        Preconditions.checkArgument((addresses.size() > 0 ? 1 : 0) != 0, (Object)"List can't be empty");
        ArrayList<String> sAddresses = new ArrayList<String>(addresses.size());
        for (MinterAddress address : addresses) {
            if (address == null) continue;
            sAddresses.add(address.toString());
        }
        Preconditions.checkArgument((sAddresses.size() > 0 ? 1 : 0) != 0, (Object)"List contains all null items");
        return ((ExplorerAddressEndpoint)this.getInstantService(this)).balanceMultiple(sAddresses);
    }

    public Call<BCExplorerResult<AddressData>> getAddressData(MinterAddress address) {
        return this.getAddressData(address.toString());
    }

    public Call<BCExplorerResult<AddressData>> getAddressData(String address) {
        return ((ExplorerAddressEndpoint)this.getInstantService()).balance(address);
    }

    public Call<ExpResult<List<DelegationInfo>>> getDelegations(MinterAddress address) {
        Preconditions.checkNotNull((Object)address, (String)"Address can't be null");
        return ((ExplorerAddressEndpoint)this.getInstantService()).getDelegationsForAddress(address.toString());
    }

    @Nonnull
    protected Class<ExplorerAddressEndpoint> getServiceClass() {
        return ExplorerAddressEndpoint.class;
    }

    public void configure(ApiService.Builder api) {
        api.registerTypeAdapter(AddressData.class, (Object)new ExplorerAddressDataDeserializer());
    }
}

