/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.models;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import javax.annotation.Nullable;
import network.minter.blockchain.models.BCResult;

public class BCExplorerResult<Result> {
    public int statusCode = 200;
    @SerializedName(value="data")
    public Result result;
    public ErrorResult error;

    public static <T> BCExplorerResult<T> copyError(BCExplorerResult<?> another) {
        BCExplorerResult out = new BCExplorerResult();
        out.statusCode = another.statusCode;
        out.error = another.error;
        return out;
    }

    public String getMessage() {
        if (this.error == null) {
            return null;
        }
        return this.error.message;
    }

    public BCResult.ResultCode getErrorCode() {
        if (this.error == null) {
            return BCResult.ResultCode.Success;
        }
        return BCResult.ResultCode.findByCode((int)this.error.code);
    }

    public boolean isSuccess() {
        return this.statusCode == 200 && this.getErrorCode() == BCResult.ResultCode.Success;
    }

    public static class ErrorResult {
        @SerializedName(value="log")
        public String message;
        public int code;
        @Nullable
        public String coin;
        @Nullable
        public BigDecimal value;

        public BCResult.ResultCode getResultCode() {
            return BCResult.ResultCode.findByCode((int)this.code);
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

