/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.ExplorerSettingsEndpoint;
import network.minter.explorer.models.BalanceChannel;
import network.minter.explorer.models.ExpResult;
import retrofit2.Call;

public class ExplorerSettingsRepository
extends DataRepository<ExplorerSettingsEndpoint> {
    public ExplorerSettingsRepository(@NonNull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<ExpResult<BalanceChannel>> getBalanceChannel(@NonNull List<MinterAddress> addresses, String userId) {
        Preconditions.checkNotNull(addresses, (String)"Addresses can't be null");
        ArrayList<String> addressStrings = new ArrayList<String>(addresses.size());
        for (MinterAddress address : addresses) {
            addressStrings.add(address.toString());
        }
        if (userId == null) {
            return ((ExplorerSettingsEndpoint)this.getInstantService()).getBalanceChannel(addressStrings);
        }
        return ((ExplorerSettingsEndpoint)this.getInstantService()).getBalanceChannel(addressStrings, userId);
    }

    @NonNull
    protected Class<ExplorerSettingsEndpoint> getServiceClass() {
        return ExplorerSettingsEndpoint.class;
    }
}

