/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.models;

import android.support.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import network.minter.blockchain.models.BCResult;

public class BCExplorerResult<Result> {
    public int statusCode = 200;
    @SerializedName(value="data")
    public Result result;
    public ErrorResult error;

    public static <T> BCExplorerResult<T> copyError(BCExplorerResult<?> another) {
        BCExplorerResult out = new BCExplorerResult();
        out.statusCode = another.statusCode;
        out.error = another.error;
        return out;
    }

    public String getMessage() {
        if (this.error == null) {
            return null;
        }
        return this.error.message;
    }

    public BCResult.ResultCode getErrorCode() {
        if (this.error == null) {
            return BCResult.ResultCode.Success;
        }
        return this.error.code;
    }

    public boolean isSuccess() {
        return this.statusCode == 200 && this.getErrorCode() == BCResult.ResultCode.Success;
    }

    public static class ErrorResult {
        @SerializedName(value="log")
        public String message;
        public BCResult.ResultCode code = BCResult.ResultCode.Success;
        @Nullable
        public String coin;
        @Nullable
        public BigDecimal value;
    }
}

