/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer;

import android.os.Build;
import com.google.gson.GsonBuilder;
import java.math.BigInteger;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterHash;
import network.minter.core.crypto.MinterPublicKey;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.api.converters.BigIntegerDeserializer;
import network.minter.core.internal.api.converters.BytesDataDeserializer;
import network.minter.core.internal.api.converters.MinterAddressDeserializer;
import network.minter.core.internal.api.converters.MinterHashDeserializer;
import network.minter.core.internal.api.converters.MinterPublicKeyDeserializer;
import network.minter.explorer.repo.ExplorerAddressRepository;
import network.minter.explorer.repo.ExplorerTransactionRepository;
import okhttp3.HttpUrl;
import okhttp3.logging.HttpLoggingInterceptor;

public class MinterExplorerApi {
    public static final String FRONT_URL = "https://explorer.beta.minter.network";
    private static final String BASE_API_URL = "https://testnet.explorer.minter.network/api/";
    private static final String DATE_FORMAT = Build.VERSION.SDK_INT >= 24 ? "yyyy-MM-dd HH:mm:ssX" : "yyyy-MM-dd HH:mm:ssZ";
    private static MinterExplorerApi INSTANCE;
    private ApiService.Builder mApiService = new ApiService.Builder("https://testnet.explorer.minter.network/api/", this.getGsonBuilder());
    private ExplorerTransactionRepository mTransactionRepository;
    private ExplorerAddressRepository mAddressRepository;

    private MinterExplorerApi() {
        this.mApiService.addHeader("Content-Type", "application/json");
        this.mApiService.addHeader("X-Minter-Client-Name", "MinterAndroid (explorer)");
        this.mApiService.addHeader("X-Minter-Client-Version", "0.1.0");
        this.mApiService.setDateFormat(DATE_FORMAT);
    }

    public static void initialize() {
        MinterExplorerApi.initialize(false);
    }

    public static void initialize(boolean debug) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new MinterExplorerApi();
        MinterExplorerApi.INSTANCE.mApiService.setDebug(debug);
        if (debug) {
            MinterExplorerApi.INSTANCE.mApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
        }
    }

    public static HttpUrl.Builder newFrontUrl() {
        return HttpUrl.parse((String)FRONT_URL).newBuilder();
    }

    public static MinterExplorerApi getInstance() {
        return INSTANCE;
    }

    public ExplorerTransactionRepository transactions() {
        if (this.mTransactionRepository == null) {
            this.mTransactionRepository = new ExplorerTransactionRepository(this.mApiService);
        }
        return this.mTransactionRepository;
    }

    public ApiService.Builder getApiService() {
        return this.mApiService;
    }

    public ExplorerAddressRepository address() {
        if (this.mAddressRepository == null) {
            this.mAddressRepository = new ExplorerAddressRepository(this.mApiService);
        }
        return this.mAddressRepository;
    }

    public GsonBuilder getGsonBuilder() {
        GsonBuilder out = new GsonBuilder();
        out.setDateFormat(DATE_FORMAT);
        out.registerTypeAdapter(MinterAddress.class, (Object)new MinterAddressDeserializer());
        out.registerTypeAdapter(MinterPublicKey.class, (Object)new MinterPublicKeyDeserializer());
        out.registerTypeAdapter(MinterHash.class, (Object)new MinterHashDeserializer());
        out.registerTypeAdapter(BigInteger.class, (Object)new BigIntegerDeserializer());
        out.registerTypeAdapter(BytesData.class, (Object)new BytesDataDeserializer());
        return out;
    }
}

