/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.RLPBoxed;

public final class TxCoinBuy
extends Operation {
    public static final Parcelable.Creator<TxCoinBuy> CREATOR = new Parcelable.Creator<TxCoinBuy>(){

        public TxCoinBuy createFromParcel(Parcel parcel) {
            return new TxCoinBuy(parcel);
        }

        public TxCoinBuy[] newArray(int n) {
            return new TxCoinBuy[n];
        }
    };
    private BigInteger mCoinIdToBuy;
    private BigInteger mValueToBuy;
    private BigInteger mCoinIdToSell;
    private BigInteger mMaxValueToSell;

    public TxCoinBuy() {
    }

    public TxCoinBuy(Transaction transaction) {
        super(transaction);
    }

    protected TxCoinBuy(Parcel parcel) {
        super(parcel);
        this.mCoinIdToBuy = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mValueToBuy = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mCoinIdToSell = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mMaxValueToSell = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxCoinBuy txCoinBuy = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txCoinBuy.mCoinIdToBuy);
        parcel.writeValue((Object)this.mValueToBuy);
        parcel.writeValue((Object)this.mCoinIdToSell);
        parcel.writeValue((Object)this.mMaxValueToSell);
    }

    public BigInteger getCoinIdToBuy() {
        return this.mCoinIdToBuy;
    }

    public TxCoinBuy setCoinIdToBuy(BigInteger bigInteger) {
        this.mCoinIdToBuy = bigInteger;
        return this;
    }

    public TxCoinBuy setCoinIdToBuy(long l) {
        return this.setCoinIdToBuy(BigInteger.valueOf(l));
    }

    public BigInteger getCoinIdToSell() {
        return this.mCoinIdToSell;
    }

    public TxCoinBuy setCoinIdToSell(BigInteger bigInteger) {
        this.mCoinIdToSell = bigInteger;
        return this;
    }

    public TxCoinBuy setCoinIdToSell(long l) {
        return this.setCoinIdToSell(BigInteger.valueOf(l));
    }

    public BigDecimal getMaxValueToSell() {
        return Transaction.humanizeValue(this.mMaxValueToSell);
    }

    public BigInteger getValueToBuyBigInteger() {
        return this.mValueToBuy;
    }

    public TxCoinBuy setMaxValueToSell(@Nonnull CharSequence charSequence) {
        return this.setMaxValueToSell(new BigDecimal(charSequence.toString()));
    }

    public TxCoinBuy setValueToBuy(BigInteger bigInteger) {
        this.mValueToBuy = bigInteger;
        return this;
    }

    public TxCoinBuy setMaxValueToSell(BigDecimal bigDecimal) {
        return this.setMaxValueToSell(Transaction.normalizeValue(bigDecimal));
    }

    public BigDecimal getValueToBuy() {
        return Transaction.humanizeValue(this.mValueToBuy);
    }

    public TxCoinBuy setMaxValueToSell(BigInteger bigInteger) {
        this.mMaxValueToSell = bigInteger;
        return this;
    }

    public TxCoinBuy setValueToBuy(BigDecimal bigDecimal) {
        return this.setValueToBuy(Transaction.normalizeValue(bigDecimal));
    }

    public TxCoinBuy setValueToBuy(@Nonnull CharSequence charSequence) {
        return this.setValueToBuy(new BigDecimal(charSequence.toString()));
    }

    @Override
    public OperationType getType() {
        return OperationType.BuyCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mCoinToBuy";
        boolean bl = ((TxCoinBuy)((Object)fieldsValidationResult2)).mCoinIdToBuy != null;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Coin to buy must be set");
        string = "mCoinToSell";
        bl = ((TxCoinBuy)((Object)fieldsValidationResult2)).mCoinIdToSell != null;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Coin to sell must be set");
        string = "mValueToBuy";
        bl = ((TxCoinBuy)((Object)fieldsValidationResult2)).mValueToBuy != null;
        TxCoinBuy txCoinBuy = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl, "Value must be set");
        object = "mMaxValueToSell";
        boolean bl2 = txCoinBuy.mMaxValueToSell != null;
        return fieldsValidationResult2.addResult((String)object, bl2, "Maximum value to sell must be set");
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mCoinIdToBuy;
        objectArray2[1] = this.mValueToBuy;
        objectArray2[2] = this.mCoinIdToSell;
        objectArray[3] = this.mMaxValueToSell;
        return RLPBoxed.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull char[] cArray) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = objectArray3;
        Object[] objectArray3 = (Object[])RLPBoxed.decode((char[])cArray, (int)0).getDecoded();
        objectArray2.mCoinIdToBuy = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(0, objectArray3));
        objectArray2.mValueToBuy = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(1, objectArray3));
        objectArray2.mCoinIdToSell = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(2, objectArray3));
        objectArray2.mMaxValueToSell = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(3, objectArray3));
    }
}

