/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import java.util.Map;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.BlockchainStatus;
import network.minter.core.internal.common.Preconditions;
import org.parceler.Parcel;

public class NodeResult {
    public Error error;

    public int getCode() {
        Error error = ((NodeResult)((Object)error)).error;
        if (error == null) {
            return 0;
        }
        return error.code;
    }

    public String getMessage() {
        Error error = ((NodeResult)((Object)error)).error;
        if (error == null) {
            return null;
        }
        return error.message;
    }

    public BlockchainStatus getStatus() {
        if (this.error == null) {
            return BlockchainStatus.Success;
        }
        return BlockchainStatus.findByCode(this.getCode());
    }

    public boolean isOk() {
        return this.error == null;
    }

    @Nonnull
    public String toString() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = Preconditions.firstNonNull((Object)this.getCode(), (Object[])new Integer[]{0});
        objectArray[1] = Preconditions.firstNonNull((Object)this.getMessage(), (Object[])new String[]{"OK"});
        return String.format("NodeResult{code=%s, message=%s}", objectArray2);
    }

    @Parcel
    public static class Error {
        public Integer code;
        public String message;
        public Map<String, String> data;
    }
}

