package network.minter.blockchain.samples.events;

import java.math.BigInteger;

import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import network.minter.blockchain.MinterBlockChainSDK;
import network.minter.blockchain.models.EventList;
import network.minter.blockchain.models.operational.OperationInvalidDataException;
import network.minter.blockchain.repo.NodeEventRepository;

public class get {

    public static void main(String[] args) throws OperationInvalidDataException {
        MinterBlockChainSDK.initialize("https://minter-node-1.testnet.minter.network:8841");

        NodeEventRepository repository = MinterBlockChainSDK.getInstance().event();

        BigInteger blockHeight = new BigInteger("100");
        Observable<EventList> request = repository.getEvents(blockHeight);

        // for android use RxJava for android and recommended schedulers:
        // request
        //  .observeOn(Schedulers.io)
        //  .subscribeOn(AndroidSchedulers.mainThread())
        //  .subscribe(result -> {}, err -> {})
        request
                .subscribeOn(Schedulers.computation())
                .blockingSubscribe(result -> {
                    // handle result
                }, err -> {
                    // handle error
                });
    }
}
