package network.minter.blockchain.samples.validators;

import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import network.minter.blockchain.MinterBlockChainSDK;
import network.minter.blockchain.models.ValidatorItem;
import network.minter.blockchain.models.ValidatorList;
import network.minter.blockchain.repo.NodeValidatorRepository;

public class get {

    public static void main(String[] args) {
        MinterBlockChainSDK.initialize("https://minter-node-1.testnet.minter.network:8841");

        NodeValidatorRepository repository = MinterBlockChainSDK.getInstance().validator();

        Observable<ValidatorList> request = repository.getValidators();

        // for android use RxJava for android and recommended schedulers:
        // request
        //  .observeOn(Schedulers.io)
        //  .subscribeOn(AndroidSchedulers.mainThread())
        //  .subscribe(result -> {}, err -> {})
        request
                .subscribeOn(Schedulers.computation())
                .blockingSubscribe(result -> {
                    for (ValidatorItem tx : result.items) {
                        // handle result
                    }
                }, err -> {
                    // handle error
                });
    }
}
