/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterPublicKey;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.RLPBoxed;

public final class TxDelegate
extends Operation {
    public static final Parcelable.Creator<TxDelegate> CREATOR = new Parcelable.Creator<TxDelegate>(){

        public TxDelegate createFromParcel(Parcel parcel) {
            return new TxDelegate(parcel);
        }

        public TxDelegate[] newArray(int n) {
            return new TxDelegate[n];
        }
    };
    private MinterPublicKey mPubKey;
    private BigInteger mCoinId;
    private BigInteger mStake;

    public TxDelegate() {
    }

    public TxDelegate(Transaction transaction) {
        super(transaction);
    }

    protected TxDelegate(Parcel parcel) {
        super(parcel);
        this.mPubKey = (MinterPublicKey)parcel.readValue(MinterPublicKey.class.getClassLoader());
        this.mCoinId = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mStake = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxDelegate txDelegate = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txDelegate.mPubKey);
        parcel.writeValue((Object)this.mCoinId);
        parcel.writeValue((Object)this.mStake);
    }

    public MinterPublicKey getPublicKey() {
        return this.mPubKey;
    }

    public TxDelegate setPublicKey(MinterPublicKey minterPublicKey) {
        this.mPubKey = minterPublicKey;
        return this;
    }

    public TxDelegate setPublicKey(String string) {
        MinterPublicKey minterPublicKey;
        TxDelegate txDelegate = txDelegate2;
        TxDelegate txDelegate2 = minterPublicKey;
        minterPublicKey = new MinterPublicKey((CharSequence)string);
        txDelegate.mPubKey = txDelegate2;
        return txDelegate;
    }

    public TxDelegate setPublicKey(byte[] byArray) {
        MinterPublicKey minterPublicKey;
        TxDelegate txDelegate = txDelegate2;
        TxDelegate txDelegate2 = minterPublicKey;
        minterPublicKey = new MinterPublicKey(byArray);
        txDelegate.mPubKey = txDelegate2;
        return txDelegate;
    }

    public BigInteger getCoinId() {
        return this.mCoinId;
    }

    public TxDelegate setCoinId(BigInteger bigInteger) {
        this.mCoinId = bigInteger;
        return this;
    }

    public TxDelegate setCoinId(long l) {
        return this.setCoinId(BigInteger.valueOf(l));
    }

    public BigInteger getStakeBigInteger() {
        return this.mStake;
    }

    public BigDecimal getStake() {
        return Transaction.humanizeValue(this.mStake);
    }

    public TxDelegate setStake(BigInteger bigInteger) {
        this.mStake = bigInteger;
        return this;
    }

    public TxDelegate setStake(@Nonnull CharSequence charSequence) {
        return this.setStake(new BigDecimal(charSequence.toString()));
    }

    public TxDelegate setStake(BigDecimal bigDecimal) {
        this.mStake = Transaction.normalizeValue(bigDecimal);
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.Delegate;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        Object object2 = "mPubKey";
        boolean bl = ((TxDelegate)((Object)fieldsValidationResult2)).mPubKey != null;
        object = ((FieldsValidationResult)object).addResult((String)object2, bl, "Node public key must be set");
        object2 = "mCoin";
        bl = ((TxDelegate)((Object)fieldsValidationResult2)).mCoinId != null;
        TxDelegate txDelegate = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult((String)object2, bl, "Coin ID must be set");
        object = "mStake";
        object2 = txDelegate.mStake;
        boolean bl2 = object2 != null && ((BigInteger)object2).compareTo(new BigInteger("0")) > 0;
        return fieldsValidationResult2.addResult((String)object, bl2, "Stake must be set (more than 0)");
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mPubKey;
        objectArray2[1] = this.mCoinId;
        objectArray[2] = this.mStake;
        return RLPBoxed.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull char[] objectArray) {
        TxDelegate txDelegate = this;
        objectArray = (Object[])RLPBoxed.decode((char[])objectArray, (int)0).getDecoded();
        txDelegate.mPubKey = new MinterPublicKey(this.fromRawRlp(0, objectArray));
        txDelegate.mCoinId = BytesHelper.fixBigintSignedByte((char[])txDelegate.fromRawRlp(1, objectArray));
        txDelegate.mStake = BytesHelper.fixBigintSignedByte((char[])txDelegate.fromRawRlp(2, objectArray));
    }
}

