/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterPublicKey;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.RLPBoxed;

public final class TxDeclareCandidacy
extends Operation {
    public static final Parcelable.Creator<TxDeclareCandidacy> CREATOR = new Parcelable.Creator<TxDeclareCandidacy>(){

        public TxDeclareCandidacy createFromParcel(Parcel parcel) {
            return new TxDeclareCandidacy(parcel);
        }

        public TxDeclareCandidacy[] newArray(int n) {
            return new TxDeclareCandidacy[n];
        }
    };
    private MinterAddress mAddress;
    private MinterPublicKey mPubKey;
    private Integer mCommission;
    private BigInteger mCoinId;
    private BigInteger mStake;

    public TxDeclareCandidacy() {
    }

    public TxDeclareCandidacy(Transaction transaction) {
        super(transaction);
    }

    protected TxDeclareCandidacy(Parcel parcel) {
        super(parcel);
        this.mAddress = (MinterAddress)parcel.readValue(MinterAddress.class.getClassLoader());
        this.mPubKey = (MinterPublicKey)parcel.readValue(MinterPublicKey.class.getClassLoader());
        Integer n = parcel.readByte() == 0 ? null : Integer.valueOf(parcel.readInt());
        this.mCommission = n;
        this.mCoinId = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mStake = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxDeclareCandidacy txDeclareCandidacy = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txDeclareCandidacy.mAddress);
        parcel.writeValue((Object)this.mPubKey);
        if (this.mCommission == null) {
            parcel.writeByte((byte)0);
        } else {
            parcel.writeByte((byte)1);
            parcel.writeInt(this.mCommission.intValue());
        }
        parcel.writeValue((Object)this.mCoinId);
        parcel.writeValue((Object)this.mStake);
    }

    public MinterAddress getAddress() {
        return this.mAddress;
    }

    public TxDeclareCandidacy setAddress(String string) {
        MinterAddress minterAddress;
        TxDeclareCandidacy txDeclareCandidacy = txDeclareCandidacy2;
        TxDeclareCandidacy txDeclareCandidacy2 = minterAddress;
        minterAddress = new MinterAddress((CharSequence)string);
        txDeclareCandidacy.mAddress = txDeclareCandidacy2;
        return txDeclareCandidacy;
    }

    public TxDeclareCandidacy setAddress(MinterAddress minterAddress) {
        this.mAddress = minterAddress;
        return this;
    }

    public MinterPublicKey getPublicKey() {
        return this.mPubKey;
    }

    public TxDeclareCandidacy setPublicKey(String string) {
        MinterPublicKey minterPublicKey;
        TxDeclareCandidacy txDeclareCandidacy = txDeclareCandidacy2;
        TxDeclareCandidacy txDeclareCandidacy2 = minterPublicKey;
        minterPublicKey = new MinterPublicKey((CharSequence)string);
        txDeclareCandidacy.mPubKey = txDeclareCandidacy2;
        return txDeclareCandidacy;
    }

    public TxDeclareCandidacy setPublicKey(byte[] byArray) {
        MinterPublicKey minterPublicKey;
        TxDeclareCandidacy txDeclareCandidacy = txDeclareCandidacy2;
        TxDeclareCandidacy txDeclareCandidacy2 = minterPublicKey;
        minterPublicKey = new MinterPublicKey(byArray);
        txDeclareCandidacy.mPubKey = txDeclareCandidacy2;
        return txDeclareCandidacy;
    }

    public TxDeclareCandidacy setPublicKey(MinterPublicKey minterPublicKey) {
        this.mPubKey = minterPublicKey;
        return this;
    }

    public int getCommission() {
        return this.mCommission;
    }

    public TxDeclareCandidacy setCommission(Integer n) {
        Preconditions.checkArgument((n >= 0 && n <= 100 ? 1 : 0) != 0, (Object)"Commission should be between 0 and 100");
        this.mCommission = n;
        return this;
    }

    public BigInteger getCoinId() {
        return this.mCoinId;
    }

    public TxDeclareCandidacy setCoinId(BigInteger bigInteger) {
        this.mCoinId = bigInteger;
        return this;
    }

    public TxDeclareCandidacy setCoinId(long l) {
        return this.setCoinId(BigInteger.valueOf(l));
    }

    public BigDecimal getStake() {
        return Transaction.humanizeValue(this.mStake);
    }

    public TxDeclareCandidacy setStake(@Nonnull CharSequence charSequence) {
        return this.setStake(new BigDecimal(charSequence.toString()));
    }

    public TxDeclareCandidacy setStake(BigDecimal bigDecimal) {
        this.mStake = Transaction.normalizeValue(bigDecimal);
        return this;
    }

    public TxDeclareCandidacy setStake(BigInteger bigInteger) {
        this.mStake = bigInteger;
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.DeclareCandidacy;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        Object object2 = "mAddress";
        boolean bl = ((TxDeclareCandidacy)((Object)fieldsValidationResult2)).mAddress != null;
        object = ((FieldsValidationResult)object).addResult((String)object2, bl, "Recipient address must be set");
        object2 = "mPubKey";
        bl = ((TxDeclareCandidacy)((Object)fieldsValidationResult2)).mPubKey != null;
        object = ((FieldsValidationResult)object).addResult((String)object2, bl, "Node public key must be set");
        object2 = "mCommission";
        Integer n = ((TxDeclareCandidacy)((Object)fieldsValidationResult2)).mCommission;
        boolean bl2 = n != null && n >= 0 && ((TxDeclareCandidacy)((Object)fieldsValidationResult2)).mCommission <= 100;
        object = ((FieldsValidationResult)object).addResult((String)object2, bl2, "Commission should be between 0 and 100");
        object2 = "mCoinId";
        bl2 = ((TxDeclareCandidacy)((Object)fieldsValidationResult2)).mCoinId != null;
        TxDeclareCandidacy txDeclareCandidacy = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult((String)object2, bl2, "Coin ID must be set");
        object = "mStake";
        object2 = txDeclareCandidacy.mStake;
        boolean bl3 = object2 != null && ((BigInteger)object2).compareTo(new BigInteger("0")) > 0;
        return fieldsValidationResult2.addResult((String)object, bl3, "Stake must be set (more than 0)");
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mAddress;
        objectArray2[1] = this.mPubKey;
        objectArray2[2] = this.mCommission;
        objectArray2[3] = this.mCoinId;
        objectArray[4] = this.mStake;
        return RLPBoxed.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull char[] objectArray) {
        TxDeclareCandidacy txDeclareCandidacy = this;
        objectArray = (Object[])RLPBoxed.decode((char[])objectArray, (int)0).getDecoded();
        txDeclareCandidacy.mAddress = new MinterAddress(this.fromRawRlp(0, objectArray));
        txDeclareCandidacy.mPubKey = new MinterPublicKey(this.fromRawRlp(1, objectArray));
        txDeclareCandidacy.mCommission = BytesHelper.fixBigintSignedByte((char[])txDeclareCandidacy.fromRawRlp(2, objectArray)).intValue();
        txDeclareCandidacy.mCoinId = BytesHelper.fixBigintSignedByte((char[])txDeclareCandidacy.fromRawRlp(3, objectArray));
        txDeclareCandidacy.mStake = BytesHelper.fixBigintSignedByte((char[])txDeclareCandidacy.fromRawRlp(4, objectArray));
    }
}

