package network.minter.blockchain.samples.block;

import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import network.minter.blockchain.MinterBlockChainSDK;
import network.minter.blockchain.models.BlockInfo;
import network.minter.blockchain.repo.NodeBlockRepository;


public class get {

    public static void main(String[] args) {
        MinterBlockChainSDK.initialize("https://minter-node-1.testnet.minter.network:8841");

        NodeBlockRepository repository = MinterBlockChainSDK.getInstance().block();
        Observable<BlockInfo> request = repository.getByHeight(1);

        // for android use RxJava for android and recommended schedulers:
        // request
        //  .observeOn(Schedulers.io)
        //  .subscribeOn(AndroidSchedulers.mainThread())
        //  .subscribe(result -> {}, err -> {})
        request
                .subscribeOn(Schedulers.computation())
                .blockingSubscribe(result -> {
                    // handle result
                }, err -> {
                    // handle error
                });
    }
}
