/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import network.minter.blockchain.MinterBlockChainApi;
import network.minter.blockchain.api.BlockChainTransactionEndpoint;
import network.minter.blockchain.models.BCResult;
import network.minter.blockchain.models.HistoryTransaction;
import network.minter.blockchain.models.TransactionCommissionValue;
import network.minter.blockchain.models.UnconfirmedTransactions;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterHash;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import retrofit2.Call;

public class BlockChainTransactionRepository
extends DataRepository<BlockChainTransactionEndpoint>
implements DataRepository.Configurator {
    public BlockChainTransactionRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Call<BCResult<List<HistoryTransaction>>> getTransactions(@Nonnull TQuery tQuery) {
        BlockChainTransactionRepository blockChainTransactionRepository = this;
        return ((BlockChainTransactionEndpoint)blockChainTransactionRepository.getInstantService(blockChainTransactionRepository)).getTransactions(((TQuery)Preconditions.checkNotNull((Object)tQuery, (String)"Query required")).build());
    }

    public Call<BCResult<HistoryTransaction>> getTransaction(MinterHash minterHash) {
        return this.getTransaction(minterHash.toString());
    }

    public Call<BCResult<HistoryTransaction>> getTransaction(String string) {
        BlockChainTransactionRepository blockChainTransactionRepository = this;
        return ((BlockChainTransactionEndpoint)blockChainTransactionRepository.getInstantService(blockChainTransactionRepository)).getTransaction(string);
    }

    public void configure(ApiService.Builder builder) {
        TransactionSignDeserializer transactionSignDeserializer;
        HistoryTransactionDeserializer historyTransactionDeserializer;
        ApiService.Builder builder2 = builder;
        Object object = historyTransactionDeserializer;
        historyTransactionDeserializer = new HistoryTransactionDeserializer();
        builder2.registerTypeAdapter(HistoryTransaction.class, object);
        object = transactionSignDeserializer;
        transactionSignDeserializer = new TransactionSignDeserializer();
        builder2.registerTypeAdapter(TransactionSign.class, object);
    }

    public Call<BCResult<TransactionCommissionValue>> getTransactionCommission(TransactionSign transactionSign) {
        return this.getTransactionCommission(transactionSign.getTxSign());
    }

    public Call<BCResult<TransactionCommissionValue>> getTransactionCommission(String string) {
        return ((BlockChainTransactionEndpoint)this.getInstantService()).getTxCommission(string);
    }

    public Call<BCResult<UnconfirmedTransactions>> getUnconfirmedList() {
        return ((BlockChainTransactionEndpoint)this.getInstantService()).getUnconfirmed();
    }

    @Nonnull
    protected Class<BlockChainTransactionEndpoint> getServiceClass() {
        return BlockChainTransactionEndpoint.class;
    }

    public static class TQuery {
        private final Map<String, String> mData = new HashMap<String, String>();

        private String normalizeAddress(String string) {
            String string2 = string.substring(0, 2);
            if (!(string2.equals("Mx") || string2.equals("Mx".toLowerCase()) || string2.equals("0x"))) {
                return string;
            }
            return string.substring(2);
        }

        public TQuery setFrom(MinterAddress minterAddress) {
            return this.setFrom(minterAddress.toString());
        }

        public TQuery setTo(MinterAddress minterAddress) {
            return this.setTo(minterAddress.toString());
        }

        public TQuery setTo(String string) {
            TQuery tQuery = this;
            tQuery.mData.put("tx.to", this.normalizeAddress(string));
            return tQuery;
        }

        public TQuery setFrom(String string) {
            TQuery tQuery = this;
            tQuery.mData.put("tx.from", this.normalizeAddress(string));
            return tQuery;
        }

        public String build() {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : this.mData.entrySet()) {
                stringBuilder2.append(entry.getKey()).append("=").append("'").append(entry.getValue()).append("'");
                if (1 >= this.mData.size()) continue;
                stringBuilder2.append('&');
            }
            return stringBuilder2.toString();
        }
    }

    public static final class HistoryTransactionDeserializer
    implements JsonDeserializer<HistoryTransaction> {
        public HistoryTransaction deserialize(JsonElement jsonElement, Type object, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (!jsonElement.isJsonNull() && jsonElement.isJsonObject()) {
                HistoryTransactionDeserializer historyTransactionDeserializer = MinterBlockChainApi.getInstance().getGsonBuilder().create();
                object = (HistoryTransaction)historyTransactionDeserializer.fromJson(jsonElement, HistoryTransaction.class);
                ((HistoryTransaction)object).data = (HistoryTransaction.TxBaseResult)historyTransactionDeserializer.fromJson((JsonElement)jsonElement.getAsJsonObject().get("data").getAsJsonObject(), ((HistoryTransaction)object).type.getOpClass());
                return object;
            }
            return null;
        }
    }

    public static final class TransactionSignDeserializer
    implements JsonDeserializer<TransactionSign> {
        public TransactionSign deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (!jsonElement.isJsonNull() && jsonElement.isJsonPrimitive()) {
                String string = jsonElement.getAsString();
                return new TransactionSign(string);
            }
            return null;
        }
    }
}

