/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterCheck;
import network.minter.core.crypto.MinterPublicKey;
import org.parceler.Parcel;

@Parcel
public class HistoryTransaction {
    public BytesData hash;
    @SerializedName(value="raw_tx")
    public BytesData rawTx;
    public MinterAddress from;
    public BigInteger nonce;
    public Type type;
    @SerializedName(value="gas_price")
    public int gasPrice;
    public int gas;
    @SerializedName(value="gas_coin")
    public String gasCoin;
    public String payload;
    @SerializedName(value="service_data")
    public String serviceData;
    public TxBaseResult data;
    public Map<String, String> tags;

    @Parcel
    public static class CandidateEditResult {
        @SerializedName(value="reward_address")
        public MinterAddress rewardAddress;
        @SerializedName(value="owner_address")
        public MinterAddress ownerAddress;
        @SerializedName(value="pub_key")
        public MinterPublicKey pubKey;
    }

    @Parcel
    public static class TxEditCandidateResult
    extends TxBaseResult {
        @SerializedName(value="list")
        public List<CandidateEditResult> items;
    }

    @Parcel
    public static class TxMultisendResult
    extends TxBaseResult {
        @SerializedName(value="list")
        public List<TxSendCoinResult> items;
    }

    @Parcel
    public static class TxCreateMultisigResult
    extends TxBaseResult {
        public BigInteger threshold;
        public List<BigInteger> weights = new ArrayList<BigInteger>();
        public List<MinterAddress> addresses = new ArrayList<MinterAddress>();
    }

    @Parcel
    public static class TxRedeemCheckResult
    extends TxBaseResult {
        @SerializedName(value="raw_check")
        public MinterCheck rawCheck;
        public BytesData proof;

        public BytesData getProof() {
            return this.proof;
        }

        public MinterCheck getRawCheck() {
            return this.rawCheck;
        }
    }

    @Parcel
    public static class TxDelegateUnbondResult
    extends TxBaseResult {
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public String coin;
        public String value;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        public BigDecimal getValue() {
            String string = this.value;
            if (string == null || string.isEmpty()) {
                this.value = "0";
            }
            return new BigDecimal(this.value);
        }

        @Deprecated
        public BigDecimal getStake() {
            return this.getValue();
        }

        public String getCoin() {
            String string = ((TxDelegateUnbondResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }
    }

    @Parcel
    public static class TxSetCandidateOnlineOfflineResult
    extends TxBaseResult {
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }
    }

    @Parcel
    public static class TxDeclareCandidacyResult
    extends TxBaseResult {
        public MinterAddress address;
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public int commission;
        public String coin;
        public BigInteger stake;

        public MinterAddress getAddress() {
            return this.address;
        }

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        public int getCommission() {
            return this.commission;
        }

        public String getCoin() {
            String string = ((TxDeclareCandidacyResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getStake() {
            if (this.stake == null) {
                this.stake = BigInteger.ZERO;
            }
            return new BigDecimal(this.stake).divide(Transaction.VALUE_MUL_DEC);
        }
    }

    @Parcel
    public static class TxConvertCoinResult
    extends TxBaseResult {
        @SerializedName(value="coin_to_sell")
        public String coinToSell;
        @SerializedName(value="coin_to_buy")
        public String coinToBuy;
        @SerializedName(value="value_to_buy")
        public BigInteger valueToBuy;
        @SerializedName(value="value_to_sell")
        public BigInteger valueToSell;
        @SerializedName(value="minimum_value_to_buy")
        public BigInteger minValueToBuy;
        @SerializedName(value="maximum_value_to_sell")
        public BigInteger maxValueToSell;

        public String getCoinToSell() {
            String string = ((TxConvertCoinResult)((Object)string)).coinToSell;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public String getCoinToBuy() {
            String string = ((TxConvertCoinResult)((Object)string)).coinToBuy;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getValueToBuy() {
            if (this.valueToBuy == null) {
                this.valueToBuy = BigInteger.ZERO;
            }
            return new BigDecimal(this.valueToBuy).divide(Transaction.VALUE_MUL_DEC);
        }

        public BigDecimal getValueToSell() {
            if (this.valueToSell == null) {
                this.valueToSell = BigInteger.ZERO;
            }
            return new BigDecimal(this.valueToSell).divide(Transaction.VALUE_MUL_DEC);
        }
    }

    @Parcel
    public static class TxCreateResult
    extends TxBaseResult {
        public String name;
        public String symbol;
        @SerializedName(value="initial_amount")
        public BigInteger initialAmount;
        @SerializedName(value="initial_reserve")
        public BigInteger initialReserve;
        @SerializedName(value="constant_reserve_ratio")
        public BigDecimal constantReserveRatio;

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            String string = ((TxCreateResult)((Object)string)).symbol;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getInitialAmount() {
            return new BigDecimal(this.initialAmount).divide(Transaction.VALUE_MUL_DEC);
        }

        public BigDecimal getInitialReserve() {
            return new BigDecimal(this.initialReserve).divide(Transaction.VALUE_MUL_DEC);
        }

        public BigDecimal getConstantReserveRatio() {
            return this.constantReserveRatio;
        }
    }

    @Parcel
    public static class TxSendCoinResult
    extends TxBaseResult {
        public MinterAddress to;
        public String coin;
        @SerializedName(value="value")
        public BigInteger amount;

        public MinterAddress getTo() {
            return this.to;
        }

        public String getCoin() {
            String string = ((TxSendCoinResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getAmount() {
            return new BigDecimal(this.amount).divide(Transaction.VALUE_MUL_DEC);
        }
    }

    @Parcel
    public static class TxBaseResult {
    }

    public static enum Type {
        Send(TxSendCoinResult.class),
        SellCoin(TxConvertCoinResult.class),
        SellAllCoins(TxConvertCoinResult.class),
        BuyCoin(TxConvertCoinResult.class),
        CreateCoin(TxCreateResult.class),
        DeclareCandidacy(TxDeclareCandidacyResult.class),
        Delegate(TxDelegateUnbondResult.class),
        Unbond(TxDelegateUnbondResult.class),
        RedeemCheck(TxRedeemCheckResult.class),
        SetCandidateOnline(TxSetCandidateOnlineOfflineResult.class),
        SetCandidateOffline(TxSetCandidateOnlineOfflineResult.class),
        CreateMultisig(TxCreateMultisigResult.class),
        Multisend(TxMultisendResult.class),
        EditCandidate(TxEditCandidateResult.class);

        Class<? extends TxBaseResult> mCls;

        private Type(Class<? extends TxBaseResult> clazz) {
            this.mCls = clazz;
        }

        public Class<? extends TxBaseResult> getOpClass() {
            return this.mCls;
        }
    }
}

