/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.blockchain.models.operational.TxSendCoin;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.util.RLPBoxed;

public class TxMultisend
extends Operation {
    public static final Parcelable.Creator<TxMultisend> CREATOR = new Parcelable.Creator<TxMultisend>(){

        public TxMultisend createFromParcel(Parcel parcel) {
            return new TxMultisend(parcel);
        }

        public TxMultisend[] newArray(int n) {
            return new TxMultisend[n];
        }
    };
    private List<TxSendCoin> mItems = new ArrayList<TxSendCoin>();

    public TxMultisend(@Nonnull Transaction transaction) {
        super(transaction);
    }

    protected TxMultisend(Parcel parcel) {
        super(parcel);
        if (parcel.readByte() == 1) {
            this.mItems = new ArrayList<TxSendCoin>();
            parcel.readList(this.mItems, TxSendCoin.class.getClassLoader());
        } else {
            this.mItems = Collections.emptyList();
        }
    }

    public List<TxSendCoin> getItems() {
        return this.mItems;
    }

    public TxSendCoin getItem(int n) {
        return this.mItems.size() > n && n > -1 ? this.mItems.get(n) : null;
    }

    public TxMultisend addItem(String string, MinterAddress minterAddress, double d) {
        TxMultisend txMultisend = this;
        txMultisend.mItems.add(new TxSendCoin(this.getTx()).setCoin(string).setTo(minterAddress).setValue(d));
        return txMultisend;
    }

    public TxMultisend addItem(String string, MinterAddress minterAddress, BigDecimal bigDecimal) {
        TxMultisend txMultisend = this;
        txMultisend.mItems.add(new TxSendCoin(this.getTx()).setCoin(string).setTo(minterAddress).setValue(bigDecimal));
        return txMultisend;
    }

    public TxMultisend addItem(String string, String string2, String string3) {
        TxMultisend txMultisend = this;
        txMultisend.mItems.add(new TxSendCoin(this.getTx()).setCoin(string).setTo(string2).setValue(string3));
        return txMultisend;
    }

    public TxMultisend addItem(String string, String string2, double d) {
        TxMultisend txMultisend = this;
        txMultisend.mItems.add(new TxSendCoin(this.getTx()).setCoin(string).setTo(string2).setValue(d));
        return txMultisend;
    }

    public TxMultisend addItem(TxSendCoin txSendCoin) {
        TxMultisend txMultisend = this;
        txMultisend.mItems.add(txSendCoin);
        return txMultisend;
    }

    @Override
    public OperationType getType() {
        return OperationType.Multisend;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxMultisend txMultisend = this;
        super.writeToParcel(parcel, n);
        if (txMultisend.mItems == null) {
            parcel.writeByte((byte)0);
        } else {
            parcel.writeByte((byte)1);
            parcel.writeList(this.mItems);
        }
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        TxMultisend txMultisend = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mItems";
        boolean bl = txMultisend.mItems.size() > 0;
        return fieldsValidationResult2.addResult(string, bl, "You should add at least one send transaction data");
    }

    @Override
    protected void decodeRLP(@Nonnull char[] objectArray) {
        objectArray = (Object[])((Object[])RLPBoxed.decode((char[])objectArray, (int)0).getDecoded())[0];
        this.mItems = new LinkedList<TxSendCoin>();
        for (int i = 0; i < objectArray.length; ++i) {
            TxSendCoin txSendCoin;
            TxSendCoin txSendCoin2 = txSendCoin;
            txSendCoin2(this.getTx());
            txSendCoin.decodeRaw(this.objArrToByteArrArr((Object[])objectArray[i]));
            this.mItems.add(i, txSendCoin2);
        }
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[][] objectArray = new Object[this.mItems.size()][3];
        for (int i = 0; i < this.mItems.size(); ++i) {
            Object[] objectArray2 = new Object[3];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = this.mItems.get(i).getCoinRaw();
            objectArray3[1] = this.mItems.get(i).getTo();
            objectArray2[2] = this.mItems.get(i).getValueBigInteger();
            objectArray[i] = objectArray2;
        }
        return RLPBoxed.encode((Object)new Object[]{objectArray});
    }
}

