/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.PublicKey;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLPBoxed;

public final class TxUnbound
extends Operation {
    public static final Parcelable.Creator<TxUnbound> CREATOR = new Parcelable.Creator<TxUnbound>(){

        public TxUnbound createFromParcel(Parcel parcel) {
            return new TxUnbound(parcel);
        }

        public TxUnbound[] newArray(int n) {
            return new TxUnbound[n];
        }
    };
    private PublicKey mPubKey;
    private String mCoin;
    private BigInteger mValue;

    public TxUnbound(Transaction transaction) {
        super(transaction);
    }

    protected TxUnbound(Parcel parcel) {
        super(parcel);
        this.mPubKey = (PublicKey)parcel.readValue(PublicKey.class.getClassLoader());
        this.mCoin = parcel.readString();
        this.mValue = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxUnbound txUnbound = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txUnbound.mPubKey);
        parcel.writeString(this.mCoin);
        parcel.writeValue((Object)this.mValue);
    }

    public PublicKey getPublicKey() {
        return this.mPubKey;
    }

    public TxUnbound setPublicKey(byte[] byArray) {
        this.mPubKey = new PublicKey(byArray);
        return this;
    }

    public TxUnbound setPublicKey(PublicKey publicKey) {
        this.mPubKey = publicKey;
        return this;
    }

    public TxUnbound setPublicKey(String string) {
        this.mPubKey = new PublicKey((CharSequence)string);
        return this;
    }

    public String getCoin() {
        return this.mCoin.replace("\u0000", "");
    }

    public TxUnbound setCoin(String string) {
        this.mCoin = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return this;
    }

    public BigInteger getValueBigInteger() {
        return this.mValue;
    }

    public BigDecimal getValue() {
        return new BigDecimal(this.mValue).divide(Transaction.VALUE_MUL_DEC);
    }

    public TxUnbound setValue(BigDecimal bigDecimal) {
        this.mValue = bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger();
        return this;
    }

    public TxUnbound setValue(BigInteger bigInteger) {
        this.mValue = bigInteger;
        return this;
    }

    public TxUnbound setValue(CharSequence charSequence) {
        Preconditions.checkNotNull((Object)charSequence);
        return this.setValue(new BigDecimal(charSequence.toString()));
    }

    @Override
    public OperationType getType() {
        return OperationType.Unbound;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mCoin";
        String string2 = ((TxUnbound)((Object)fieldsValidationResult2)).mCoin;
        boolean bl = string2 != null && string2.length() > 2 && ((TxUnbound)((Object)fieldsValidationResult2)).mCoin.length() < 11;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Coin symbol length must be from 3 to 10 chars");
        string = "mPubKey";
        bl = ((TxUnbound)((Object)fieldsValidationResult2)).mPubKey != null;
        TxUnbound txUnbound = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl, "Node Public key must be set");
        object = "mValue";
        boolean bl2 = txUnbound.mValue != null;
        return fieldsValidationResult2.addResult((String)object, bl2, "Value must be set");
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mPubKey.getData();
        objectArray2[1] = this.mCoin;
        objectArray[2] = this.mValue;
        return RLPBoxed.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull char[] objectArray) {
        TxUnbound txUnbound = this;
        objectArray = (Object[])RLPBoxed.decode((char[])objectArray, (int)0).getDecoded();
        txUnbound.mPubKey = new PublicKey(this.fromRawRlp(0, objectArray));
        txUnbound.mCoin = StringHelper.charsToString((char[])txUnbound.fromRawRlp(1, objectArray), (int)10);
        txUnbound.mValue = BytesHelper.fixBigintSignedByte((char[])txUnbound.fromRawRlp(2, objectArray));
    }
}

