/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.PublicKey;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLP;

public final class TxDelegate
extends Operation {
    public static final Parcelable.Creator<TxDelegate> CREATOR = new Parcelable.Creator<TxDelegate>(){

        public TxDelegate createFromParcel(Parcel parcel) {
            return new TxDelegate(parcel);
        }

        public TxDelegate[] newArray(int n) {
            return new TxDelegate[n];
        }
    };
    private PublicKey mPubKey;
    private String mCoin;
    private BigInteger mStake;

    public TxDelegate(Transaction transaction) {
        super(transaction);
    }

    protected TxDelegate(Parcel parcel) {
        super(parcel);
        this.mPubKey = (PublicKey)parcel.readValue(PublicKey.class.getClassLoader());
        this.mCoin = parcel.readString();
        this.mStake = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxDelegate txDelegate = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txDelegate.mPubKey);
        parcel.writeString(this.mCoin);
        parcel.writeValue((Object)this.mStake);
    }

    public PublicKey getPublicKey() {
        return this.mPubKey;
    }

    public TxDelegate setPublicKey(PublicKey publicKey) {
        this.mPubKey = publicKey;
        return this;
    }

    public TxDelegate setPublicKey(String string) {
        this.mPubKey = new PublicKey((CharSequence)string);
        return this;
    }

    public TxDelegate setPublicKey(byte[] byArray) {
        this.mPubKey = new PublicKey(byArray);
        return this;
    }

    public String getCoin() {
        return this.mCoin.replace("\u0000", "");
    }

    public TxDelegate setCoin(String string) {
        this.mCoin = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return this;
    }

    public BigInteger getStakeBigInteger() {
        return this.mStake;
    }

    public BigDecimal getStake() {
        return new BigDecimal(this.mStake).divide(Transaction.VALUE_MUL_DEC);
    }

    public TxDelegate setStake(BigInteger bigInteger) {
        this.mStake = bigInteger;
        return this;
    }

    public double getStakeDouble() {
        return this.getStake().doubleValue();
    }

    public TxDelegate setStake(double d) {
        return this.setStake(new BigDecimal(String.valueOf(d)));
    }

    public TxDelegate setStake(String string) {
        this.mStake = new BigInteger(string);
        return this;
    }

    public TxDelegate setStake(BigDecimal bigDecimal) {
        this.mStake = bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger();
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.Delegate;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        Object object2 = "mPubKey";
        boolean bl = ((TxDelegate)((Object)fieldsValidationResult2)).mPubKey != null;
        object = ((FieldsValidationResult)object).addResult((String)object2, bl, "Node public key must be set");
        object2 = "mCoin";
        String string = ((TxDelegate)((Object)fieldsValidationResult2)).mCoin;
        boolean bl2 = string != null && string.length() > 2 && ((TxDelegate)((Object)fieldsValidationResult2)).mCoin.length() < 11;
        TxDelegate txDelegate = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult((String)object2, bl2, "Coin symbol length must be from 3 to 10 chars");
        object = "mStake";
        object2 = txDelegate.mStake;
        boolean bl3 = object2 != null && ((BigInteger)object2).compareTo(new BigInteger("0")) > 0;
        return fieldsValidationResult2.addResult((String)object, bl3, "Stake must be set (more than 0)");
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mPubKey.getData();
        objectArray2[1] = this.mCoin;
        objectArray[2] = this.mStake;
        return RLP.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] objectArray) {
        TxDelegate txDelegate = this;
        objectArray = (Object[])RLP.decode((byte[])objectArray, (int)0).getDecoded();
        txDelegate.mPubKey = new PublicKey(this.fromRawRlp(0, objectArray));
        txDelegate.mCoin = StringHelper.bytesToString((byte[])txDelegate.fromRawRlp(1, objectArray));
        txDelegate.mStake = BytesHelper.fixBigintSignedByte((byte[])txDelegate.fromRawRlp(2, objectArray));
    }
}

