/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.converters.MinterAddressDeserializer;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.RLP;

public class TxCreateMultisigAddress
extends Operation {
    public static final Parcelable.Creator<TxCreateMultisigAddress> CREATOR = new Parcelable.Creator<TxCreateMultisigAddress>(){

        public TxCreateMultisigAddress createFromParcel(Parcel parcel) {
            return new TxCreateMultisigAddress(parcel);
        }

        public TxCreateMultisigAddress[] newArray(int n) {
            return new TxCreateMultisigAddress[n];
        }
    };
    private BigInteger mThreshold;
    private List<BigInteger> mWeights = new LinkedList<BigInteger>();
    private List<MinterAddress> mAddresses = new LinkedList<MinterAddress>();

    public TxCreateMultisigAddress(@Nonnull Transaction transaction) {
        super(transaction);
    }

    protected TxCreateMultisigAddress(Parcel parcel) {
        super(parcel);
        this.mThreshold = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        parcel.readList(this.mWeights, BigInteger.class.getClassLoader());
        parcel.readList(this.mAddresses, MinterAddressDeserializer.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxCreateMultisigAddress txCreateMultisigAddress = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txCreateMultisigAddress.mThreshold);
        parcel.writeList(this.mWeights);
        parcel.writeList(this.mAddresses);
    }

    public TxCreateMultisigAddress setThreshold(long l) {
        this.mThreshold = new BigInteger(String.valueOf(l));
        return this;
    }

    public TxCreateMultisigAddress addWeight(long ... lArray) {
        for (long l : lArray) {
            this.mWeights.add(new BigInteger(String.valueOf(l)));
        }
        return this;
    }

    public TxCreateMultisigAddress addAddress(MinterAddress minterAddress) {
        TxCreateMultisigAddress txCreateMultisigAddress = this;
        txCreateMultisigAddress.mAddresses.add(minterAddress);
        return txCreateMultisigAddress;
    }

    @Override
    public OperationType getType() {
        return OperationType.CreateMultisigAddress;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mThreshold";
        boolean bl = ((TxCreateMultisigAddress)((Object)fieldsValidationResult2)).mThreshold != null;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Threshold is required");
        string = "mWeights";
        bl = ((TxCreateMultisigAddress)((Object)fieldsValidationResult2)).mWeights.size() > 0;
        TxCreateMultisigAddress txCreateMultisigAddress = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl, "You should add at least 1 weight");
        object = "mAddresses";
        boolean bl2 = txCreateMultisigAddress.mAddresses != null;
        return fieldsValidationResult2.addResult((String)object, bl2, "You should add at least 1 address");
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] objectArray) {
        Object[] objectArray2 = (Object[])RLP.decode((byte[])objectArray, (int)0).getDecoded();
        objectArray = objectArray2;
        this.mThreshold = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(0, objectArray));
        Object[] objectArray3 = (Object[])objectArray2[1];
        this.mWeights = new LinkedList<BigInteger>();
        int n = objectArray3.length;
        for (int i = 0; i < n; ++i) {
            byte[][] byArray = this.objArrToByteArrArr((Object[])objectArray3[i]);
            int n2 = byArray.length;
            for (int j = 0; j < n2; ++j) {
                byte[] byArray2 = byArray[j];
                this.mWeights.add(BytesHelper.fixBigintSignedByte((byte[])byArray2));
            }
        }
        Object[] objectArray4 = (Object[])objectArray[2];
        objectArray = objectArray4;
        this.mAddresses = new LinkedList<MinterAddress>();
        int n3 = objectArray4.length;
        for (n = 0; n < n3; ++n) {
            for (byte[] byArray : this.objArrToByteArrArr((Object[])objectArray[n])) {
                this.mAddresses.add(new MinterAddress(byArray));
            }
        }
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        TxCreateMultisigAddress txCreateMultisigAddress = this;
        List<BigInteger> list = txCreateMultisigAddress.mWeights;
        BigInteger[] bigIntegerArray = list.toArray(new BigInteger[list.size()]);
        byte[][] byArrayArray = new byte[txCreateMultisigAddress.mAddresses.size()][];
        for (int i = 0; i < this.mAddresses.size(); ++i) {
            byArrayArray[i] = this.mAddresses.get(i).getData();
        }
        return RLP.encode((Object)new Object[]{this.mThreshold, bigIntegerArray, byArrayArray});
    }
}

