/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;

public class BCResult<Result> {
    public int statusCode = 200;
    @SerializedName(value="result")
    public Result result;
    public ErrorResult error;

    public static <T> BCResult<T> copyError(BCResult<?> another) {
        BCResult out = new BCResult();
        out.statusCode = another.statusCode;
        out.error = another.error;
        return out;
    }

    public boolean isOk() {
        return this.error == null && this.result != null;
    }

    @Nonnull
    public String toString() {
        return String.format("BCResult{code=%s, result=%s, message=%s}", this.error != null ? this.error.getResultCode().name() : "{no error code}", this.result != null ? "{has result: " + this.result.getClass().getName() + "}" : "null", this.error != null ? this.error.getMessage() : "null");
    }

    @Deprecated
    public boolean isSuccess() {
        return this.statusCode == 200 && this.error == null;
    }

    public static final class ErrorResult {
        public int code;
        public String message;
        public String data;

        public ResultCode getResultCode() {
            return ResultCode.findByCode(this.code);
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            if (this.data == null || this.data.isEmpty()) {
                return this.message;
            }
            return this.data;
        }
    }

    public static enum ResultCode {
        UnknownError(-1),
        Success(0),
        WrongNonce(101),
        CoinNotExists(102),
        CoinReserveNotSufficient(103),
        TxTooLarge(105),
        DecodeError(106),
        InsufficientFunds(107),
        TxPayloadTooLarge(109),
        TxServiceDataTooLarge(110),
        InvalidMultisendData(111),
        CoinSupplyOverflow(112),
        TxFromSenderAlreadyInMempool(113),
        TooLowGasPrice(114),
        CoinAlreadyExists(201),
        WrongCrr(202),
        InvalidCoinSymbol(203),
        InvalidCoinName(204),
        WrongCoinSupply(205),
        CrossConvert(301),
        MaximumValueToSellReached(302),
        MinimumValueToBuylReached(303),
        CandidateExists(401),
        WrongCommission(402),
        CandidateNotFound(403),
        StakeNotFound(404),
        InsufficientStake(405),
        IsNotOwnerOfCandidate(406),
        IncorrectPubKey(407),
        StakeShouldBePositive(408),
        TooLowStake(409),
        CheckInvalidLock(501),
        CheckExpired(502),
        CheckUsed(503),
        TooHighGasPrice(504),
        WrongGasCoin(505),
        IncorrectWeights(601),
        MultisigExists(602),
        MultisigNotExists(603),
        IncorrectMultiSignature(604),
        TooLargeOwnersList(605);

        final int resVal;

        private ResultCode(int v) {
            this.resVal = v;
        }

        public int getValue() {
            return this.resVal;
        }

        public static boolean isKnownError(int code) {
            for (ResultCode c : ResultCode.values()) {
                if (code != c.getValue()) continue;
                return true;
            }
            return false;
        }

        public static ResultCode findByCode(int code) {
            for (ResultCode c : ResultCode.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return UnknownError;
        }
    }
}

