/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.api.BlockChainBlockEndpoint;
import network.minter.blockchain.models.BCResult;
import network.minter.blockchain.models.BlockInfo;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.data.DataRepository;
import retrofit2.Call;

public class BlockChainBlockRepository
extends DataRepository<BlockChainBlockEndpoint> {
    public BlockChainBlockRepository(@Nonnull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<BCResult<BlockInfo>> getByHeight(long height) {
        return ((BlockChainBlockEndpoint)this.getInstantService()).getByHeight(height);
    }

    public Call<BCResult<BigInteger>> getMinGasPrice() {
        return ((BlockChainBlockEndpoint)this.getInstantService()).getMinGas();
    }

    public Call<BCResult<BigInteger>> getMaxGasPrice() {
        return ((BlockChainBlockEndpoint)this.getInstantService()).getMaxGas();
    }

    public Call<BCResult<BigInteger>> getMaxGasPrice(long blockHeight) {
        return ((BlockChainBlockEndpoint)this.getInstantService()).getMaxGasByHeight(blockHeight);
    }

    @Nonnull
    protected Class<BlockChainBlockEndpoint> getServiceClass() {
        return BlockChainBlockEndpoint.class;
    }
}

